@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.chaos.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateAccess].
 */
@PulumiTagMarker
public class PrivateAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateAccessArgs = PrivateAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateAccessArgsBuilder.() -> Unit) {
        val builder = PrivateAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateAccess {
        val builtJavaResource = com.pulumi.azurenative.chaos.PrivateAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateAccess(builtJavaResource)
    }
}

/**
 * PrivateAccesses tracked resource.
 * Azure REST API version: 2023-10-27-preview.
 * ## Example Usage
 * ### Create or Update a private access resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateAccess = new AzureNative.Chaos.PrivateAccess("privateAccess", new()
 *     {
 *         Location = "centraluseuap",
 *         PrivateAccessName = "myPrivateAccess",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewPrivateAccess(ctx, "privateAccess", &chaos.PrivateAccessArgs{
 * 			Location:          pulumi.String("centraluseuap"),
 * 			PrivateAccessName: pulumi.String("myPrivateAccess"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.PrivateAccess;
 * import com.pulumi.azurenative.chaos.PrivateAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateAccess = new PrivateAccess("privateAccess", PrivateAccessArgs.builder()
 *             .location("centraluseuap")
 *             .privateAccessName("myPrivateAccess")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:PrivateAccess myPrivateAccess /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Chaos/privateAccesses/{privateAccessName}
 * ```
 */
public class PrivateAccess internal constructor(
    override val javaResource: com.pulumi.azurenative.chaos.PrivateAccess,
) : KotlinCustomResource(javaResource, PrivateAccessMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A readonly collection of private endpoint connection. Currently only one endpoint connection is supported.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateAccessMapper : ResourceMapper<PrivateAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.chaos.PrivateAccess::class == javaResource::class

    override fun map(javaResource: Resource): PrivateAccess = PrivateAccess(
        javaResource as
            com.pulumi.azurenative.chaos.PrivateAccess,
    )
}

/**
 * @see [PrivateAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateAccess].
 */
public suspend fun privateAccess(
    name: String,
    block: suspend PrivateAccessResourceBuilder.() -> Unit,
): PrivateAccess {
    val builder = PrivateAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateAccess(name: String): PrivateAccess {
    val builder = PrivateAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
