@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.DiscreteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a discrete action.
 * @property name String that represents a Capability URN.
 * @property parameters List of key value pairs.
 * @property selectorId String that represents a selector.
 * @property type Enum that discriminates between action models.
 * Expected value is 'discrete'.
 */
public data class DiscreteActionArgs(
    public val name: Output<String>,
    public val parameters: Output<List<KeyValuePairArgs>>,
    public val selectorId: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.DiscreteActionArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.DiscreteActionArgs =
        com.pulumi.azurenative.chaos.inputs.DiscreteActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .selectorId(selectorId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiscreteActionArgs].
 */
@PulumiTagMarker
public class DiscreteActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<List<KeyValuePairArgs>>? = null

    private var selectorId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("yyqbcjlfawnuexov")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of key value pairs.
     */
    @JvmName("uxobibdiblvpddek")
    public suspend fun parameters(`value`: Output<List<KeyValuePairArgs>>) {
        this.parameters = value
    }

    @JvmName("cvgyujnjuhrojtwc")
    public suspend fun parameters(vararg values: Output<KeyValuePairArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of key value pairs.
     */
    @JvmName("inpfcflwshwrpwwb")
    public suspend fun parameters(values: List<Output<KeyValuePairArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value String that represents a selector.
     */
    @JvmName("dftnhrbgfnsnuxxa")
    public suspend fun selectorId(`value`: Output<String>) {
        this.selectorId = value
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'discrete'.
     */
    @JvmName("kndlvgkoqvkolgxx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("hhkxryvpgqrxcuos")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of key value pairs.
     */
    @JvmName("owpqwkqauwtatodu")
    public suspend fun parameters(`value`: List<KeyValuePairArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("fbnkkqnaounvcnxs")
    public suspend fun parameters(argument: List<suspend KeyValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KeyValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("otqnchvwbmirmyxo")
    public suspend fun parameters(vararg argument: suspend KeyValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KeyValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("gdhtxpbxluscugmg")
    public suspend fun parameters(argument: suspend KeyValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeyValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of key value pairs.
     */
    @JvmName("snkipfurfbkfacth")
    public suspend fun parameters(vararg values: KeyValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value String that represents a selector.
     */
    @JvmName("qtijujwbatrjcanm")
    public suspend fun selectorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorId = mapped
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'discrete'.
     */
    @JvmName("ovkqdnapqblxptqp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DiscreteActionArgs = DiscreteActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        selectorId = selectorId ?: throw PulumiNullFieldException("selectorId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
