@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.SimpleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Model that represents a simple target filter.
 * @property parameters Model that represents the Simple filter parameters.
 * @property type Enum that discriminates between filter types. Currently only `Simple` type is supported.
 * Expected value is 'Simple'.
 */
public data class SimpleFilterArgs(
    public val parameters: Output<SimpleFilterParametersArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.SimpleFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.SimpleFilterArgs =
        com.pulumi.azurenative.chaos.inputs.SimpleFilterArgs.builder()
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimpleFilterArgs].
 */
@PulumiTagMarker
public class SimpleFilterArgsBuilder internal constructor() {
    private var parameters: Output<SimpleFilterParametersArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Model that represents the Simple filter parameters.
     */
    @JvmName("ivcfjwfnbkldpkxu")
    public suspend fun parameters(`value`: Output<SimpleFilterParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value Enum that discriminates between filter types. Currently only `Simple` type is supported.
     * Expected value is 'Simple'.
     */
    @JvmName("dldneinklfnqigdu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Model that represents the Simple filter parameters.
     */
    @JvmName("rckntaydhuoreaow")
    public suspend fun parameters(`value`: SimpleFilterParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Model that represents the Simple filter parameters.
     */
    @JvmName("axgmecnalxftatxx")
    public suspend fun parameters(argument: suspend SimpleFilterParametersArgsBuilder.() -> Unit) {
        val toBeMapped = SimpleFilterParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value Enum that discriminates between filter types. Currently only `Simple` type is supported.
     * Expected value is 'Simple'.
     */
    @JvmName("edxfkfeomofsmsln")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SimpleFilterArgs = SimpleFilterArgs(
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
