@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.SimpleFilterParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents the Simple filter parameters.
 * @property zones List of Azure availability zones to filter targets by.
 */
public data class SimpleFilterParametersArgs(
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.SimpleFilterParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.SimpleFilterParametersArgs =
        com.pulumi.azurenative.chaos.inputs.SimpleFilterParametersArgs.builder()
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SimpleFilterParametersArgs].
 */
@PulumiTagMarker
public class SimpleFilterParametersArgsBuilder internal constructor() {
    private var zones: Output<List<String>>? = null

    /**
     * @param value List of Azure availability zones to filter targets by.
     */
    @JvmName("exrlkvegiickienc")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("mgckbhrqulrfpdyt")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values List of Azure availability zones to filter targets by.
     */
    @JvmName("harlxvqavljcrdbu")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value List of Azure availability zones to filter targets by.
     */
    @JvmName("hexpobdiknqptjwp")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values List of Azure availability zones to filter targets by.
     */
    @JvmName("ommskdmdsyttpsay")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): SimpleFilterParametersArgs = SimpleFilterParametersArgs(
        zones = zones,
    )
}
