@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents the a list of actions and action statuses.
 * @property actions The array of actions.
 * @property branchId The id of the branch status.
 * @property branchName The name of the branch status.
 * @property status The status of the branch.
 */
public data class BranchStatusResponse(
    public val actions: List<ActionStatusResponse>,
    public val branchId: String,
    public val branchName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.BranchStatusResponse):
            BranchStatusResponse = BranchStatusResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.ActionStatusResponse.Companion.toKotlin(args0)
                })
            }),
            branchId = javaType.branchId(),
            branchName = javaType.branchName(),
            status = javaType.status(),
        )
    }
}
