@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents a simple target filter.
 * @property parameters Model that represents the Simple filter parameters.
 * @property type Enum that discriminates between filter types. Currently only `Simple` type is supported.
 * Expected value is 'Simple'.
 */
public data class SimpleFilterResponse(
    public val parameters: SimpleFilterParametersResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.SimpleFilterResponse):
            SimpleFilterResponse = SimpleFilterResponse(
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.SimpleFilterParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
