@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents the a list of branches and branch statuses.
 * @property branches The array of branches.
 * @property status The value of the status of the step.
 * @property stepId The id of the step.
 * @property stepName The name of the step.
 */
public data class StepStatusResponse(
    public val branches: List<BranchStatusResponse>,
    public val status: String,
    public val stepId: String,
    public val stepName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.StepStatusResponse):
            StepStatusResponse = StepStatusResponse(
            branches = javaType.branches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.BranchStatusResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            stepId = javaType.stepId(),
            stepName = javaType.stepName(),
        )
    }
}
