@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.BooleanEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * GlobalRulestack Certificate Object
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### CertificateObjectGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectGlobalRulestack = new AzureNative.Cloudngfw.CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", new()
 *     {
 *         AuditComment = "comment",
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         CertificateSignerResourceId = "",
 *         Description = "description",
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectGlobalRulestack(ctx, "certificateObjectGlobalRulestack", &cloudngfw.CertificateObjectGlobalRulestackArgs{
 * 			AuditComment:                pulumi.String("comment"),
 * 			CertificateSelfSigned:       pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			CertificateSignerResourceId: pulumi.String(""),
 * 			Description:                 pulumi.String("description"),
 * 			GlobalRulestackName:         pulumi.String("praval"),
 * 			Name:                        pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectGlobalRulestack = new CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", CertificateObjectGlobalRulestackArgs.builder()
 *             .auditComment("comment")
 *             .certificateSelfSigned("TRUE")
 *             .certificateSignerResourceId("")
 *             .description("description")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ### CertificateObjectGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectGlobalRulestack = new AzureNative.Cloudngfw.CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", new()
 *     {
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectGlobalRulestack(ctx, "certificateObjectGlobalRulestack", &cloudngfw.CertificateObjectGlobalRulestackArgs{
 * 			CertificateSelfSigned: pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			GlobalRulestackName:   pulumi.String("praval"),
 * 			Name:                  pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectGlobalRulestack = new CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", CertificateObjectGlobalRulestackArgs.builder()
 *             .certificateSelfSigned("TRUE")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:CertificateObjectGlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/certificates/{name}
 * ```
 * @property auditComment comment for this object
 * @property certificateSelfSigned use certificate self signed
 * @property certificateSignerResourceId Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
 * @property description user description for this object
 * @property globalRulestackName GlobalRulestack resource name
 * @property name certificate name
 */
public data class CertificateObjectGlobalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val certificateSelfSigned: Output<Either<String, BooleanEnum>>? = null,
    public val certificateSignerResourceId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val globalRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .certificateSelfSigned(
                certificateSelfSigned?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .certificateSignerResourceId(certificateSignerResourceId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalRulestackName(globalRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateObjectGlobalRulestackArgs].
 */
@PulumiTagMarker
public class CertificateObjectGlobalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var certificateSelfSigned: Output<Either<String, BooleanEnum>>? = null

    private var certificateSignerResourceId: Output<String>? = null

    private var description: Output<String>? = null

    private var globalRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("weqssfmronfsdjcc")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("rrhwsdnxbsaafvvb")
    public suspend fun certificateSelfSigned(`value`: Output<Either<String, BooleanEnum>>) {
        this.certificateSelfSigned = value
    }

    /**
     * @param value Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
     */
    @JvmName("hkgnxwtpscsbnxtg")
    public suspend fun certificateSignerResourceId(`value`: Output<String>) {
        this.certificateSignerResourceId = value
    }

    /**
     * @param value user description for this object
     */
    @JvmName("cpbeuehabhawdyld")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("arbeiejsmkuebogw")
    public suspend fun globalRulestackName(`value`: Output<String>) {
        this.globalRulestackName = value
    }

    /**
     * @param value certificate name
     */
    @JvmName("rtqriemooqcjygab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value comment for this object
     */
    @JvmName("wkejxdhfbgkiemne")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("mxuomhcvonuskiev")
    public suspend fun certificateSelfSigned(`value`: Either<String, BooleanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("vhxdfcodhwulaxxq")
    public fun certificateSelfSigned(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("lhgfexfndjmqabys")
    public fun certificateSelfSigned(`value`: BooleanEnum) {
        val toBeMapped = Either.ofRight<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
     */
    @JvmName("ajipwhbdywaxrhdu")
    public suspend fun certificateSignerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSignerResourceId = mapped
    }

    /**
     * @param value user description for this object
     */
    @JvmName("owcfjtrcudhcxljx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("trijodhaucmrhpvu")
    public suspend fun globalRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalRulestackName = mapped
    }

    /**
     * @param value certificate name
     */
    @JvmName("remnwlandhgnruyn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CertificateObjectGlobalRulestackArgs = CertificateObjectGlobalRulestackArgs(
        auditComment = auditComment,
        certificateSelfSigned = certificateSelfSigned,
        certificateSignerResourceId = certificateSignerResourceId,
        description = description,
        globalRulestackName = globalRulestackName,
        name = name,
    )
}
