@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.BooleanEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * LocalRulestack Certificate Object
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### CertificateObjectLocalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectLocalRulestack = new AzureNative.Cloudngfw.CertificateObjectLocalRulestack("certificateObjectLocalRulestack", new()
 *     {
 *         AuditComment = "comment",
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         CertificateSignerResourceId = "",
 *         Description = "description",
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectLocalRulestack(ctx, "certificateObjectLocalRulestack", &cloudngfw.CertificateObjectLocalRulestackArgs{
 * 			AuditComment:                pulumi.String("comment"),
 * 			CertificateSelfSigned:       pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			CertificateSignerResourceId: pulumi.String(""),
 * 			Description:                 pulumi.String("description"),
 * 			LocalRulestackName:          pulumi.String("lrs1"),
 * 			Name:                        pulumi.String("armid1"),
 * 			ResourceGroupName:           pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectLocalRulestack = new CertificateObjectLocalRulestack("certificateObjectLocalRulestack", CertificateObjectLocalRulestackArgs.builder()
 *             .auditComment("comment")
 *             .certificateSelfSigned("TRUE")
 *             .certificateSignerResourceId("")
 *             .description("description")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ### CertificateObjectLocalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectLocalRulestack = new AzureNative.Cloudngfw.CertificateObjectLocalRulestack("certificateObjectLocalRulestack", new()
 *     {
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectLocalRulestack(ctx, "certificateObjectLocalRulestack", &cloudngfw.CertificateObjectLocalRulestackArgs{
 * 			CertificateSelfSigned: pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			LocalRulestackName:    pulumi.String("lrs1"),
 * 			Name:                  pulumi.String("armid1"),
 * 			ResourceGroupName:     pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectLocalRulestack = new CertificateObjectLocalRulestack("certificateObjectLocalRulestack", CertificateObjectLocalRulestackArgs.builder()
 *             .certificateSelfSigned("TRUE")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:CertificateObjectLocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/certificates/{name}
 * ```
 * @property auditComment comment for this object
 * @property certificateSelfSigned use certificate self signed
 * @property certificateSignerResourceId Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
 * @property description user description for this object
 * @property localRulestackName LocalRulestack resource name
 * @property name certificate name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CertificateObjectLocalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val certificateSelfSigned: Output<Either<String, BooleanEnum>>? = null,
    public val certificateSignerResourceId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.CertificateObjectLocalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .certificateSelfSigned(
                certificateSelfSigned?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .certificateSignerResourceId(certificateSignerResourceId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localRulestackName(localRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateObjectLocalRulestackArgs].
 */
@PulumiTagMarker
public class CertificateObjectLocalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var certificateSelfSigned: Output<Either<String, BooleanEnum>>? = null

    private var certificateSignerResourceId: Output<String>? = null

    private var description: Output<String>? = null

    private var localRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("pcuybpkbtbyxtrpl")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("erctbgvomlttpyxp")
    public suspend fun certificateSelfSigned(`value`: Output<Either<String, BooleanEnum>>) {
        this.certificateSelfSigned = value
    }

    /**
     * @param value Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
     */
    @JvmName("luosuigmmywhekrr")
    public suspend fun certificateSignerResourceId(`value`: Output<String>) {
        this.certificateSignerResourceId = value
    }

    /**
     * @param value user description for this object
     */
    @JvmName("lfypmnqwgvsndfel")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("xqsmdsqnwyquojdu")
    public suspend fun localRulestackName(`value`: Output<String>) {
        this.localRulestackName = value
    }

    /**
     * @param value certificate name
     */
    @JvmName("vopjxolthrurrwwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nkfjpkrbinqegdns")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value comment for this object
     */
    @JvmName("ctfqecbchnyeqvjd")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("qqyrsugcuyoscyqe")
    public suspend fun certificateSelfSigned(`value`: Either<String, BooleanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("ikrjhlkhksyukdnk")
    public fun certificateSelfSigned(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value use certificate self signed
     */
    @JvmName("vrqilccklfircdjk")
    public fun certificateSelfSigned(`value`: BooleanEnum) {
        val toBeMapped = Either.ofRight<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSelfSigned = mapped
    }

    /**
     * @param value Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
     */
    @JvmName("ytgqfykcobptiwro")
    public suspend fun certificateSignerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSignerResourceId = mapped
    }

    /**
     * @param value user description for this object
     */
    @JvmName("ocighdmujnecaixb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("joupnuiuhxqyrxlh")
    public suspend fun localRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localRulestackName = mapped
    }

    /**
     * @param value certificate name
     */
    @JvmName("orsxdllosnsgodtg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yxhcktwagfvwxymx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CertificateObjectLocalRulestackArgs = CertificateObjectLocalRulestackArgs(
        auditComment = auditComment,
        certificateSelfSigned = certificateSelfSigned,
        certificateSignerResourceId = certificateSignerResourceId,
        description = description,
        localRulestackName = localRulestackName,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
