@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FqdnListLocalRulestack].
 */
@PulumiTagMarker
public class FqdnListLocalRulestackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FqdnListLocalRulestackArgs = FqdnListLocalRulestackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FqdnListLocalRulestackArgsBuilder.() -> Unit) {
        val builder = FqdnListLocalRulestackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FqdnListLocalRulestack {
        val builtJavaResource =
            com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FqdnListLocalRulestack(builtJavaResource)
    }
}

/**
 * LocalRulestack fqdnList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### FqdnListLocalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListLocalRulestack = new AzureNative.Cloudngfw.FqdnListLocalRulestack("fqdnListLocalRulestack", new()
 *     {
 *         AuditComment = "string",
 *         Description = "string",
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListLocalRulestack(ctx, "fqdnListLocalRulestack", &cloudngfw.FqdnListLocalRulestackArgs{
 * 			AuditComment: pulumi.String("string"),
 * 			Description:  pulumi.String("string"),
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListLocalRulestack = new FqdnListLocalRulestack("fqdnListLocalRulestack", FqdnListLocalRulestackArgs.builder()
 *             .auditComment("string")
 *             .description("string")
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ### FqdnListLocalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListLocalRulestack = new AzureNative.Cloudngfw.FqdnListLocalRulestack("fqdnListLocalRulestack", new()
 *     {
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListLocalRulestack(ctx, "fqdnListLocalRulestack", &cloudngfw.FqdnListLocalRulestackArgs{
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListLocalRulestack = new FqdnListLocalRulestack("fqdnListLocalRulestack", FqdnListLocalRulestackArgs.builder()
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:FqdnListLocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/fqdnlists/{name}
 * ```
 */
public class FqdnListLocalRulestack internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack,
) : KotlinCustomResource(javaResource, FqdnListLocalRulestackMapper) {
    /**
     * comment for this object
     */
    public val auditComment: Output<String>?
        get() = javaResource.auditComment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * fqdn object description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * etag info
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * fqdn list
     */
    public val fqdnList: Output<List<String>>
        get() = javaResource.fqdnList().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FqdnListLocalRulestackMapper : ResourceMapper<FqdnListLocalRulestack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack::class == javaResource::class

    override fun map(javaResource: Resource): FqdnListLocalRulestack =
        FqdnListLocalRulestack(
            javaResource as
                com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack,
        )
}

/**
 * @see [FqdnListLocalRulestack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FqdnListLocalRulestack].
 */
public suspend fun fqdnListLocalRulestack(
    name: String,
    block: suspend FqdnListLocalRulestackResourceBuilder.() -> Unit,
): FqdnListLocalRulestack {
    val builder = FqdnListLocalRulestackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FqdnListLocalRulestack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fqdnListLocalRulestack(name: String): FqdnListLocalRulestack {
    val builder = FqdnListLocalRulestackResourceBuilder()
    builder.name(name)
    return builder.build()
}
