@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * LocalRulestack fqdnList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### FqdnListLocalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListLocalRulestack = new AzureNative.Cloudngfw.FqdnListLocalRulestack("fqdnListLocalRulestack", new()
 *     {
 *         AuditComment = "string",
 *         Description = "string",
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListLocalRulestack(ctx, "fqdnListLocalRulestack", &cloudngfw.FqdnListLocalRulestackArgs{
 * 			AuditComment: pulumi.String("string"),
 * 			Description:  pulumi.String("string"),
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListLocalRulestack = new FqdnListLocalRulestack("fqdnListLocalRulestack", FqdnListLocalRulestackArgs.builder()
 *             .auditComment("string")
 *             .description("string")
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ### FqdnListLocalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListLocalRulestack = new AzureNative.Cloudngfw.FqdnListLocalRulestack("fqdnListLocalRulestack", new()
 *     {
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListLocalRulestack(ctx, "fqdnListLocalRulestack", &cloudngfw.FqdnListLocalRulestackArgs{
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListLocalRulestack = new FqdnListLocalRulestack("fqdnListLocalRulestack", FqdnListLocalRulestackArgs.builder()
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:FqdnListLocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/fqdnlists/{name}
 * ```
 * @property auditComment comment for this object
 * @property description fqdn object description
 * @property fqdnList fqdn list
 * @property localRulestackName LocalRulestack resource name
 * @property name fqdn list name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class FqdnListLocalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fqdnList: Output<List<String>>? = null,
    public val localRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.FqdnListLocalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fqdnList(fqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .localRulestackName(localRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FqdnListLocalRulestackArgs].
 */
@PulumiTagMarker
public class FqdnListLocalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var description: Output<String>? = null

    private var fqdnList: Output<List<String>>? = null

    private var localRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("revgrrdxamxonjsx")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value fqdn object description
     */
    @JvmName("ehsdhxyatebiqggc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value fqdn list
     */
    @JvmName("glsiijxtprcgntvg")
    public suspend fun fqdnList(`value`: Output<List<String>>) {
        this.fqdnList = value
    }

    @JvmName("huwacexrdlwhsyaw")
    public suspend fun fqdnList(vararg values: Output<String>) {
        this.fqdnList = Output.all(values.asList())
    }

    /**
     * @param values fqdn list
     */
    @JvmName("conveofkacpbxysv")
    public suspend fun fqdnList(values: List<Output<String>>) {
        this.fqdnList = Output.all(values)
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("byaeejalbsauksdg")
    public suspend fun localRulestackName(`value`: Output<String>) {
        this.localRulestackName = value
    }

    /**
     * @param value fqdn list name
     */
    @JvmName("wkqrukochhgevnxc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hpergdsaeissgncy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value comment for this object
     */
    @JvmName("jtahlbukmnfakldb")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value fqdn object description
     */
    @JvmName("qjdrrlkmdyxylkar")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value fqdn list
     */
    @JvmName("ievyrulrrxxagchw")
    public suspend fun fqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnList = mapped
    }

    /**
     * @param values fqdn list
     */
    @JvmName("orietfprbbmnkxvu")
    public suspend fun fqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnList = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("rcqbemdefkdepghw")
    public suspend fun localRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localRulestackName = mapped
    }

    /**
     * @param value fqdn list name
     */
    @JvmName("glgbkaufhvqheiwy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("etticjwpocwfbklp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): FqdnListLocalRulestackArgs = FqdnListLocalRulestackArgs(
        auditComment = auditComment,
        description = description,
        fqdnList = fqdnList,
        localRulestackName = localRulestackName,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
