@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.DefaultMode
import com.pulumi.azurenative.cloudngfw.kotlin.enums.ScopeType
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SecurityServicesArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SecurityServicesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * PaloAltoNetworks GlobalRulestack
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### GlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalRulestack = new AzureNative.Cloudngfw.GlobalRulestack("globalRulestack", new()
 *     {
 *         AssociatedSubscriptions = new[]
 *         {
 *             "2bf4a339-294d-4c25-b0b2-ef649e9f5c27",
 *         },
 *         DefaultMode = AzureNative.Cloudngfw.DefaultMode.IPS,
 *         Description = "global rulestacks",
 *         GlobalRulestackName = "praval",
 *         Identity = new AzureNative.Cloudngfw.Inputs.AzureResourceManagerManagedIdentityPropertiesArgs
 *         {
 *             Type = AzureNative.Cloudngfw.ManagedIdentityType.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key16", new AzureNative.Cloudngfw.Inputs.AzureResourceManagerUserAssignedIdentityArgs
 *                 {
 *                     ClientId = "aaaa",
 *                     PrincipalId = "aaaaaaaaaaaaaaa",
 *                 } },
 *             },
 *         },
 *         Location = "eastus",
 *         MinAppIdVersion = "8.5.3",
 *         PanEtag = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *         PanLocation = "eastus",
 *         Scope = AzureNative.Cloudngfw.ScopeType.GLOBAL,
 *         SecurityServices = new AzureNative.Cloudngfw.Inputs.SecurityServicesArgs
 *         {
 *             AntiSpywareProfile = "default",
 *             AntiVirusProfile = "default",
 *             DnsSubscription = "default",
 *             FileBlockingProfile = "default",
 *             OutboundTrustCertificate = "default",
 *             OutboundUnTrustCertificate = "default",
 *             UrlFilteringProfile = "default",
 *             VulnerabilityProfile = "default",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewGlobalRulestack(ctx, "globalRulestack", &cloudngfw.GlobalRulestackArgs{
 * 			AssociatedSubscriptions: pulumi.StringArray{
 * 				pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c27"),
 * 			},
 * 			DefaultMode:         pulumi.String(cloudngfw.DefaultModeIPS),
 * 			Description:         pulumi.String("global rulestacks"),
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Identity: &cloudngfw.AzureResourceManagerManagedIdentityPropertiesArgs{
 * 				Type: pulumi.String(cloudngfw.ManagedIdentityTypeNone),
 * 				UserAssignedIdentities: cloudngfw.AzureResourceManagerUserAssignedIdentityMap{
 * 					"key16": &cloudngfw.AzureResourceManagerUserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("aaaa"),
 * 						PrincipalId: pulumi.String("aaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			Location:        pulumi.String("eastus"),
 * 			MinAppIdVersion: pulumi.String("8.5.3"),
 * 			PanEtag:         pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 			PanLocation:     pulumi.String("eastus"),
 * 			Scope:           pulumi.String(cloudngfw.ScopeTypeGLOBAL),
 * 			SecurityServices: &cloudngfw.SecurityServicesArgs{
 * 				AntiSpywareProfile:         pulumi.String("default"),
 * 				AntiVirusProfile:           pulumi.String("default"),
 * 				DnsSubscription:            pulumi.String("default"),
 * 				FileBlockingProfile:        pulumi.String("default"),
 * 				OutboundTrustCertificate:   pulumi.String("default"),
 * 				OutboundUnTrustCertificate: pulumi.String("default"),
 * 				UrlFilteringProfile:        pulumi.String("default"),
 * 				VulnerabilityProfile:       pulumi.String("default"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.GlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalRulestack = new GlobalRulestack("globalRulestack", GlobalRulestackArgs.builder()
 *             .associatedSubscriptions("2bf4a339-294d-4c25-b0b2-ef649e9f5c27")
 *             .defaultMode("IPS")
 *             .description("global rulestacks")
 *             .globalRulestackName("praval")
 *             .identity(AzureResourceManagerManagedIdentityPropertiesArgs.builder()
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key16", Map.ofEntries(
 *                     Map.entry("clientId", "aaaa"),
 *                     Map.entry("principalId", "aaaaaaaaaaaaaaa")
 *                 )))
 *                 .build())
 *             .location("eastus")
 *             .minAppIdVersion("8.5.3")
 *             .panEtag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *             .panLocation("eastus")
 *             .scope("GLOBAL")
 *             .securityServices(SecurityServicesArgs.builder()
 *                 .antiSpywareProfile("default")
 *                 .antiVirusProfile("default")
 *                 .dnsSubscription("default")
 *                 .fileBlockingProfile("default")
 *                 .outboundTrustCertificate("default")
 *                 .outboundUnTrustCertificate("default")
 *                 .urlFilteringProfile("default")
 *                 .vulnerabilityProfile("default")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### GlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalRulestack = new AzureNative.Cloudngfw.GlobalRulestack("globalRulestack", new()
 *     {
 *         GlobalRulestackName = "praval",
 *         Location = "eastus",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewGlobalRulestack(ctx, "globalRulestack", &cloudngfw.GlobalRulestackArgs{
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Location:            pulumi.String("eastus"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.GlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalRulestack = new GlobalRulestack("globalRulestack", GlobalRulestackArgs.builder()
 *             .globalRulestackName("praval")
 *             .location("eastus")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:GlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}
 * ```
 * @property associatedSubscriptions subscription scope of global rulestack
 * @property defaultMode Mode for default rules creation
 * @property description rulestack description
 * @property globalRulestackName GlobalRulestack resource name
 * @property identity The managed service identities assigned to this resource.
 * @property location Global Location
 * @property minAppIdVersion minimum version
 * @property panEtag PanEtag info
 * @property panLocation Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
 * @property scope Rulestack Type
 * @property securityServices Security Profile
 */
public data class GlobalRulestackArgs(
    public val associatedSubscriptions: Output<List<String>>? = null,
    public val defaultMode: Output<Either<String, DefaultMode>>? = null,
    public val description: Output<String>? = null,
    public val globalRulestackName: Output<String>? = null,
    public val identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val minAppIdVersion: Output<String>? = null,
    public val panEtag: Output<String>? = null,
    public val panLocation: Output<String>? = null,
    public val scope: Output<Either<String, ScopeType>>? = null,
    public val securityServices: Output<SecurityServicesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.GlobalRulestackArgs.builder()
            .associatedSubscriptions(
                associatedSubscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .defaultMode(
                defaultMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .globalRulestackName(globalRulestackName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minAppIdVersion(minAppIdVersion?.applyValue({ args0 -> args0 }))
            .panEtag(panEtag?.applyValue({ args0 -> args0 }))
            .panLocation(panLocation?.applyValue({ args0 -> args0 }))
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .securityServices(
                securityServices?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GlobalRulestackArgs].
 */
@PulumiTagMarker
public class GlobalRulestackArgsBuilder internal constructor() {
    private var associatedSubscriptions: Output<List<String>>? = null

    private var defaultMode: Output<Either<String, DefaultMode>>? = null

    private var description: Output<String>? = null

    private var globalRulestackName: Output<String>? = null

    private var identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var minAppIdVersion: Output<String>? = null

    private var panEtag: Output<String>? = null

    private var panLocation: Output<String>? = null

    private var scope: Output<Either<String, ScopeType>>? = null

    private var securityServices: Output<SecurityServicesArgs>? = null

    /**
     * @param value subscription scope of global rulestack
     */
    @JvmName("wgsivefcvtfypwhm")
    public suspend fun associatedSubscriptions(`value`: Output<List<String>>) {
        this.associatedSubscriptions = value
    }

    @JvmName("bsuryobmiyewnlee")
    public suspend fun associatedSubscriptions(vararg values: Output<String>) {
        this.associatedSubscriptions = Output.all(values.asList())
    }

    /**
     * @param values subscription scope of global rulestack
     */
    @JvmName("jecetonucgfnxfma")
    public suspend fun associatedSubscriptions(values: List<Output<String>>) {
        this.associatedSubscriptions = Output.all(values)
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("xaauggdgetamgfmg")
    public suspend fun defaultMode(`value`: Output<Either<String, DefaultMode>>) {
        this.defaultMode = value
    }

    /**
     * @param value rulestack description
     */
    @JvmName("kouwbhlnsimbgpwk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("yaiakcvewwgpthqw")
    public suspend fun globalRulestackName(`value`: Output<String>) {
        this.globalRulestackName = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("tvpjhftpsklndpim")
    public suspend fun identity(`value`: Output<AzureResourceManagerManagedIdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value Global Location
     */
    @JvmName("mehcysacpidwfacr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value minimum version
     */
    @JvmName("gxraysoulmexaken")
    public suspend fun minAppIdVersion(`value`: Output<String>) {
        this.minAppIdVersion = value
    }

    /**
     * @param value PanEtag info
     */
    @JvmName("lmihkvxhdfnkigsi")
    public suspend fun panEtag(`value`: Output<String>) {
        this.panEtag = value
    }

    /**
     * @param value Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
     */
    @JvmName("drelmvauusebxori")
    public suspend fun panLocation(`value`: Output<String>) {
        this.panLocation = value
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("hxsnnmingxsnxvvh")
    public suspend fun scope(`value`: Output<Either<String, ScopeType>>) {
        this.scope = value
    }

    /**
     * @param value Security Profile
     */
    @JvmName("rpolselrullcovjb")
    public suspend fun securityServices(`value`: Output<SecurityServicesArgs>) {
        this.securityServices = value
    }

    /**
     * @param value subscription scope of global rulestack
     */
    @JvmName("pioliakrgdfgmqkf")
    public suspend fun associatedSubscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedSubscriptions = mapped
    }

    /**
     * @param values subscription scope of global rulestack
     */
    @JvmName("ahopyvronnhipgem")
    public suspend fun associatedSubscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associatedSubscriptions = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("tdlevmihwgiiqujd")
    public suspend fun defaultMode(`value`: Either<String, DefaultMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("ygjlkugqhtximecq")
    public fun defaultMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("uertvevjbwspxyfr")
    public fun defaultMode(`value`: DefaultMode) {
        val toBeMapped = Either.ofRight<String, DefaultMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value rulestack description
     */
    @JvmName("ndslaagujmkpfauq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("bbjtbsyxkpkbblnx")
    public suspend fun globalRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalRulestackName = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("sdemrcuhagaavecu")
    public suspend fun identity(`value`: AzureResourceManagerManagedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("noatxlemwwfpwyec")
    public suspend
    fun identity(argument: suspend AzureResourceManagerManagedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureResourceManagerManagedIdentityPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Global Location
     */
    @JvmName("qlgebopckcraodgx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value minimum version
     */
    @JvmName("gqygobvfnkqrcwpg")
    public suspend fun minAppIdVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minAppIdVersion = mapped
    }

    /**
     * @param value PanEtag info
     */
    @JvmName("jduvjovedfgpoqyh")
    public suspend fun panEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panEtag = mapped
    }

    /**
     * @param value Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
     */
    @JvmName("qkxptrafqhggsfta")
    public suspend fun panLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panLocation = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("gsjpoqydibofsreb")
    public suspend fun scope(`value`: Either<String, ScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("vveprlaymskbmdoj")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("sgctiimarsfxvqmp")
    public fun scope(`value`: ScopeType) {
        val toBeMapped = Either.ofRight<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Security Profile
     */
    @JvmName("ojewawssswmibiyl")
    public suspend fun securityServices(`value`: SecurityServicesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityServices = mapped
    }

    /**
     * @param argument Security Profile
     */
    @JvmName("birvwfwffkotxyga")
    public suspend fun securityServices(argument: suspend SecurityServicesArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityServicesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityServices = mapped
    }

    internal fun build(): GlobalRulestackArgs = GlobalRulestackArgs(
        associatedSubscriptions = associatedSubscriptions,
        defaultMode = defaultMode,
        description = description,
        globalRulestackName = globalRulestackName,
        identity = identity,
        location = location,
        minAppIdVersion = minAppIdVersion,
        panEtag = panEtag,
        panLocation = panLocation,
        scope = scope,
        securityServices = securityServices,
    )
}
