@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.CategoryResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.DestinationAddrResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SourceAddrResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.TagInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.CategoryResponse.Companion.toKotlin as categoryResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.DestinationAddrResponse.Companion.toKotlin as destinationAddrResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SourceAddrResponse.Companion.toKotlin as sourceAddrResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.TagInfoResponse.Companion.toKotlin as tagInfoResponseToKotlin

/**
 * Builder for [PostRule].
 */
@PulumiTagMarker
public class PostRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PostRuleArgs = PostRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PostRuleArgsBuilder.() -> Unit) {
        val builder = PostRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PostRule {
        val builtJavaResource = com.pulumi.azurenative.cloudngfw.PostRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PostRule(builtJavaResource)
    }
}

/**
 * PostRulestack rule list
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### PostRules_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postRule = new AzureNative.Cloudngfw.PostRule("postRule", new()
 *     {
 *         ActionType = AzureNative.Cloudngfw.ActionEnum.Allow,
 *         Applications = new[]
 *         {
 *             "app1",
 *         },
 *         AuditComment = "example comment",
 *         Category = new AzureNative.Cloudngfw.Inputs.CategoryArgs
 *         {
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             UrlCustom = new[]
 *             {
 *                 "https://microsoft.com",
 *             },
 *         },
 *         DecryptionRuleType = AzureNative.Cloudngfw.DecryptionRuleTypeEnum.SSLOutboundInspection,
 *         Description = "description of post rule",
 *         Destination = new AzureNative.Cloudngfw.Inputs.DestinationAddrArgs
 *         {
 *             Cidrs = new[]
 *             {
 *                 "1.0.0.1/10",
 *             },
 *             Countries = new[]
 *             {
 *                 "India",
 *             },
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             FqdnLists = new[]
 *             {
 *                 "FQDN1",
 *             },
 *             PrefixLists = new[]
 *             {
 *                 "PL1",
 *             },
 *         },
 *         EnableLogging = AzureNative.Cloudngfw.StateEnum.DISABLED,
 *         GlobalRulestackName = "lrs1",
 *         InboundInspectionCertificate = "cert1",
 *         NegateDestination = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         NegateSource = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         Priority = "1",
 *         Protocol = "HTTP",
 *         ProtocolPortList = new[]
 *         {
 *             "80",
 *         },
 *         RuleName = "postRule1",
 *         RuleState = AzureNative.Cloudngfw.StateEnum.DISABLED,
 *         Source = new AzureNative.Cloudngfw.Inputs.SourceAddrArgs
 *         {
 *             Cidrs = new[]
 *             {
 *                 "1.0.0.1/10",
 *             },
 *             Countries = new[]
 *             {
 *                 "India",
 *             },
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             PrefixLists = new[]
 *             {
 *                 "PL1",
 *             },
 *         },
 *         Tags = new[]
 *         {
 *             new AzureNative.Cloudngfw.Inputs.TagInfoArgs
 *             {
 *                 Key = "keyName",
 *                 Value = "value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPostRule(ctx, "postRule", &cloudngfw.PostRuleArgs{
 * 			ActionType: pulumi.String(cloudngfw.ActionEnumAllow),
 * 			Applications: pulumi.StringArray{
 * 				pulumi.String("app1"),
 * 			},
 * 			AuditComment: pulumi.String("example comment"),
 * 			Category: &cloudngfw.CategoryArgs{
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				UrlCustom: pulumi.StringArray{
 * 					pulumi.String("https://microsoft.com"),
 * 				},
 * 			},
 * 			DecryptionRuleType: pulumi.String(cloudngfw.DecryptionRuleTypeEnumSSLOutboundInspection),
 * 			Description:        pulumi.String("description of post rule"),
 * 			Destination: &cloudngfw.DestinationAddrArgs{
 * 				Cidrs: pulumi.StringArray{
 * 					pulumi.String("1.0.0.1/10"),
 * 				},
 * 				Countries: pulumi.StringArray{
 * 					pulumi.String("India"),
 * 				},
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				FqdnLists: pulumi.StringArray{
 * 					pulumi.String("FQDN1"),
 * 				},
 * 				PrefixLists: pulumi.StringArray{
 * 					pulumi.String("PL1"),
 * 				},
 * 			},
 * 			EnableLogging:                pulumi.String(cloudngfw.StateEnumDISABLED),
 * 			GlobalRulestackName:          pulumi.String("lrs1"),
 * 			InboundInspectionCertificate: pulumi.String("cert1"),
 * 			NegateDestination:            pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			NegateSource:                 pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			Priority:                     pulumi.String("1"),
 * 			Protocol:                     pulumi.String("HTTP"),
 * 			ProtocolPortList: pulumi.StringArray{
 * 				pulumi.String("80"),
 * 			},
 * 			RuleName:  pulumi.String("postRule1"),
 * 			RuleState: pulumi.String(cloudngfw.StateEnumDISABLED),
 * 			Source: &cloudngfw.SourceAddrArgs{
 * 				Cidrs: pulumi.StringArray{
 * 					pulumi.String("1.0.0.1/10"),
 * 				},
 * 				Countries: pulumi.StringArray{
 * 					pulumi.String("India"),
 * 				},
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				PrefixLists: pulumi.StringArray{
 * 					pulumi.String("PL1"),
 * 				},
 * 			},
 * 			Tags: cloudngfw.TagInfoArray{
 * 				&cloudngfw.TagInfoArgs{
 * 					Key:   pulumi.String("keyName"),
 * 					Value: pulumi.String("value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PostRule;
 * import com.pulumi.azurenative.cloudngfw.PostRuleArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postRule = new PostRule("postRule", PostRuleArgs.builder()
 *             .actionType("Allow")
 *             .applications("app1")
 *             .auditComment("example comment")
 *             .category(CategoryArgs.builder()
 *                 .feeds("feed")
 *                 .urlCustom("https://microsoft.com")
 *                 .build())
 *             .decryptionRuleType("SSLOutboundInspection")
 *             .description("description of post rule")
 *             .destination(DestinationAddrArgs.builder()
 *                 .cidrs("1.0.0.1/10")
 *                 .countries("India")
 *                 .feeds("feed")
 *                 .fqdnLists("FQDN1")
 *                 .prefixLists("PL1")
 *                 .build())
 *             .enableLogging("DISABLED")
 *             .globalRulestackName("lrs1")
 *             .inboundInspectionCertificate("cert1")
 *             .negateDestination("TRUE")
 *             .negateSource("TRUE")
 *             .priority("1")
 *             .protocol("HTTP")
 *             .protocolPortList("80")
 *             .ruleName("postRule1")
 *             .ruleState("DISABLED")
 *             .source(SourceAddrArgs.builder()
 *                 .cidrs("1.0.0.1/10")
 *                 .countries("India")
 *                 .feeds("feed")
 *                 .prefixLists("PL1")
 *                 .build())
 *             .tags(TagInfoArgs.builder()
 *                 .key("keyName")
 *                 .value("value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### PostRules_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postRule = new AzureNative.Cloudngfw.PostRule("postRule", new()
 *     {
 *         GlobalRulestackName = "lrs1",
 *         Priority = "1",
 *         RuleName = "postRule1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPostRule(ctx, "postRule", &cloudngfw.PostRuleArgs{
 * 			GlobalRulestackName: pulumi.String("lrs1"),
 * 			Priority:            pulumi.String("1"),
 * 			RuleName:            pulumi.String("postRule1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PostRule;
 * import com.pulumi.azurenative.cloudngfw.PostRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postRule = new PostRule("postRule", PostRuleArgs.builder()
 *             .globalRulestackName("lrs1")
 *             .priority("1")
 *             .ruleName("postRule1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:PostRule aaaaaaaaaa /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/postRules/{priority}
 * ```
 */
public class PostRule internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.PostRule,
) : KotlinCustomResource(javaResource, PostRuleMapper) {
    /**
     * rule action
     */
    public val actionType: Output<String>?
        get() = javaResource.actionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * array of rule applications
     */
    public val applications: Output<List<String>>?
        get() = javaResource.applications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * rule comment
     */
    public val auditComment: Output<String>?
        get() = javaResource.auditComment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * rule category
     */
    public val category: Output<CategoryResponse>?
        get() = javaResource.category().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    categoryResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * enable or disable decryption
     */
    public val decryptionRuleType: Output<String>?
        get() = javaResource.decryptionRuleType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * rule description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * destination address
     */
    public val destination: Output<DestinationAddrResponse>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    destinationAddrResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * enable or disable logging
     */
    public val enableLogging: Output<String>?
        get() = javaResource.enableLogging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * etag info
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * inbound Inspection Certificate
     */
    public val inboundInspectionCertificate: Output<String>?
        get() = javaResource.inboundInspectionCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * cidr should not be 'any'
     */
    public val negateDestination: Output<String>?
        get() = javaResource.negateDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * cidr should not be 'any'
     */
    public val negateSource: Output<String>?
        get() = javaResource.negateSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * any, application-default, TCP:number, UDP:number
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * prot port list
     */
    public val protocolPortList: Output<List<String>>?
        get() = javaResource.protocolPortList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * rule name
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * state of this rule
     */
    public val ruleState: Output<String>?
        get() = javaResource.ruleState().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * source address
     */
    public val source: Output<SourceAddrResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sourceAddrResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * tag for rule
     */
    public val tags: Output<List<TagInfoResponse>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> tagInfoResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PostRuleMapper : ResourceMapper<PostRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.PostRule::class == javaResource::class

    override fun map(javaResource: Resource): PostRule = PostRule(
        javaResource as
            com.pulumi.azurenative.cloudngfw.PostRule,
    )
}

/**
 * @see [PostRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PostRule].
 */
public suspend fun postRule(name: String, block: suspend PostRuleResourceBuilder.() -> Unit):
    PostRule {
    val builder = PostRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PostRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun postRule(name: String): PostRule {
    val builder = PostRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
