@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * GlobalRulestack prefixList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### PrefixListGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefixListGlobalRulestack = new AzureNative.Cloudngfw.PrefixListGlobalRulestack("prefixListGlobalRulestack", new()
 *     {
 *         AuditComment = "comment",
 *         Description = "string",
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *         PrefixList = new[]
 *         {
 *             "1.0.0.0/24",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPrefixListGlobalRulestack(ctx, "prefixListGlobalRulestack", &cloudngfw.PrefixListGlobalRulestackArgs{
 * 			AuditComment:        pulumi.String("comment"),
 * 			Description:         pulumi.String("string"),
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 			PrefixList: pulumi.StringArray{
 * 				pulumi.String("1.0.0.0/24"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefixListGlobalRulestack = new PrefixListGlobalRulestack("prefixListGlobalRulestack", PrefixListGlobalRulestackArgs.builder()
 *             .auditComment("comment")
 *             .description("string")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .prefixList("1.0.0.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ### PrefixListGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefixListGlobalRulestack = new AzureNative.Cloudngfw.PrefixListGlobalRulestack("prefixListGlobalRulestack", new()
 *     {
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *         PrefixList = new[]
 *         {
 *             "1.0.0.0/24",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPrefixListGlobalRulestack(ctx, "prefixListGlobalRulestack", &cloudngfw.PrefixListGlobalRulestackArgs{
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 			PrefixList: pulumi.StringArray{
 * 				pulumi.String("1.0.0.0/24"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefixListGlobalRulestack = new PrefixListGlobalRulestack("prefixListGlobalRulestack", PrefixListGlobalRulestackArgs.builder()
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .prefixList("1.0.0.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:PrefixListGlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/prefixlists/{name}
 * ```
 * @property auditComment comment for this object
 * @property description prefix description
 * @property globalRulestackName GlobalRulestack resource name
 * @property name Local Rule priority
 * @property prefixList prefix list
 */
public data class PrefixListGlobalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val globalRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val prefixList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.PrefixListGlobalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalRulestackName(globalRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .prefixList(prefixList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrefixListGlobalRulestackArgs].
 */
@PulumiTagMarker
public class PrefixListGlobalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var description: Output<String>? = null

    private var globalRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    private var prefixList: Output<List<String>>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("fbwenhirfrgfgbdy")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value prefix description
     */
    @JvmName("tggwaiktqktfhjkj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("vaqdrqdrepgaydrn")
    public suspend fun globalRulestackName(`value`: Output<String>) {
        this.globalRulestackName = value
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("siqbsobuvuikxjkt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value prefix list
     */
    @JvmName("fvvqvywihslrpvtn")
    public suspend fun prefixList(`value`: Output<List<String>>) {
        this.prefixList = value
    }

    @JvmName("upbvgdyltapwkavt")
    public suspend fun prefixList(vararg values: Output<String>) {
        this.prefixList = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("iejnxhycyhevgbph")
    public suspend fun prefixList(values: List<Output<String>>) {
        this.prefixList = Output.all(values)
    }

    /**
     * @param value comment for this object
     */
    @JvmName("tcsndvnxkdixhtpl")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value prefix description
     */
    @JvmName("futrjxleatjigemx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("jdgfxiquwlplcdjg")
    public suspend fun globalRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("aluqvtbahlxrygwb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("yovbhwxgjgbrrtxu")
    public suspend fun prefixList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixList = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("weaeomoniqgfskyb")
    public suspend fun prefixList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixList = mapped
    }

    internal fun build(): PrefixListGlobalRulestackArgs = PrefixListGlobalRulestackArgs(
        auditComment = auditComment,
        description = description,
        globalRulestackName = globalRulestackName,
        name = name,
        prefixList = prefixList,
    )
}
