@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * LocalRulestack prefixList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### PrefixListLocalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefixListLocalRulestack = new AzureNative.Cloudngfw.PrefixListLocalRulestack("prefixListLocalRulestack", new()
 *     {
 *         AuditComment = "comment",
 *         Description = "string",
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         PrefixList = new[]
 *         {
 *             "1.0.0.0/24",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPrefixListLocalRulestack(ctx, "prefixListLocalRulestack", &cloudngfw.PrefixListLocalRulestackArgs{
 * 			AuditComment:       pulumi.String("comment"),
 * 			Description:        pulumi.String("string"),
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			PrefixList: pulumi.StringArray{
 * 				pulumi.String("1.0.0.0/24"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefixListLocalRulestack = new PrefixListLocalRulestack("prefixListLocalRulestack", PrefixListLocalRulestackArgs.builder()
 *             .auditComment("comment")
 *             .description("string")
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .prefixList("1.0.0.0/24")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ### PrefixListLocalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefixListLocalRulestack = new AzureNative.Cloudngfw.PrefixListLocalRulestack("prefixListLocalRulestack", new()
 *     {
 *         LocalRulestackName = "lrs1",
 *         Name = "armid1",
 *         PrefixList = new[]
 *         {
 *             "1.0.0.0/24",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPrefixListLocalRulestack(ctx, "prefixListLocalRulestack", &cloudngfw.PrefixListLocalRulestackArgs{
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Name:               pulumi.String("armid1"),
 * 			PrefixList: pulumi.StringArray{
 * 				pulumi.String("1.0.0.0/24"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefixListLocalRulestack = new PrefixListLocalRulestack("prefixListLocalRulestack", PrefixListLocalRulestackArgs.builder()
 *             .localRulestackName("lrs1")
 *             .name("armid1")
 *             .prefixList("1.0.0.0/24")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:PrefixListLocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/prefixlists/{name}
 * ```
 * @property auditComment comment for this object
 * @property description prefix description
 * @property localRulestackName LocalRulestack resource name
 * @property name Local Rule priority
 * @property prefixList prefix list
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrefixListLocalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val prefixList: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.PrefixListLocalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localRulestackName(localRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .prefixList(prefixList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrefixListLocalRulestackArgs].
 */
@PulumiTagMarker
public class PrefixListLocalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var description: Output<String>? = null

    private var localRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    private var prefixList: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("lhgroiexweiqkodf")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value prefix description
     */
    @JvmName("rupfxefkhlrxcgpg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("yfnteacbjstqlecp")
    public suspend fun localRulestackName(`value`: Output<String>) {
        this.localRulestackName = value
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("siyryfwropbqbnol")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value prefix list
     */
    @JvmName("xjhhftanxycylvxs")
    public suspend fun prefixList(`value`: Output<List<String>>) {
        this.prefixList = value
    }

    @JvmName("goesabxmqcovwnek")
    public suspend fun prefixList(vararg values: Output<String>) {
        this.prefixList = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("ausexmxjvcycwrvm")
    public suspend fun prefixList(values: List<Output<String>>) {
        this.prefixList = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjfheswulbrbheev")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value comment for this object
     */
    @JvmName("nlcraexyudrfvwow")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value prefix description
     */
    @JvmName("oiareymyigxytmgh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("olnrycatbtgoaelx")
    public suspend fun localRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("mvdsusdymykqqdmj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("yfdwmepxhoxajrwf")
    public suspend fun prefixList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixList = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("cshnlfchsjaghsbl")
    public suspend fun prefixList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixList = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("reawcqsneqwjlluh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrefixListLocalRulestackArgs = PrefixListLocalRulestackArgs(
        auditComment = auditComment,
        description = description,
        localRulestackName = localRulestackName,
        name = name,
        prefixList = prefixList,
        resourceGroupName = resourceGroupName,
    )
}
