@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * different usage type like PAYG/COMMITTED
 */
public enum class UsageType(
    public val javaValue: com.pulumi.azurenative.cloudngfw.enums.UsageType,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.enums.UsageType> {
    PAYG(com.pulumi.azurenative.cloudngfw.enums.UsageType.PAYG),
    COMMITTED(com.pulumi.azurenative.cloudngfw.enums.UsageType.COMMITTED),
    ;

    override fun toJava(): com.pulumi.azurenative.cloudngfw.enums.UsageType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.enums.UsageType): UsageType =
            UsageType.values().first { it.javaValue == javaType }
    }
}
