@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerUserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A managed identity assigned by the user.
 * @property clientId The active directory client identifier for this principal.
 * @property principalId The active directory identifier for this principal.
 */
public data class AzureResourceManagerUserAssignedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerUserAssignedIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerUserAssignedIdentityArgs =
        com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerUserAssignedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureResourceManagerUserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class AzureResourceManagerUserAssignedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value The active directory client identifier for this principal.
     */
    @JvmName("mtgfnnasjqrtyaxo")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The active directory identifier for this principal.
     */
    @JvmName("tnpacqxjlwydxenk")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The active directory client identifier for this principal.
     */
    @JvmName("knwvqjlwgvmgsqcn")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The active directory identifier for this principal.
     */
    @JvmName("mlktwvtlovpbyaad")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): AzureResourceManagerUserAssignedIdentityArgs =
        AzureResourceManagerUserAssignedIdentityArgs(
            clientId = clientId,
            principalId = principalId,
        )
}
