@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.DNSProxy
import com.pulumi.azurenative.cloudngfw.kotlin.enums.EnabledDNSType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DNS Proxy settings for Firewall
 * @property dnsServers List of IPs associated with the Firewall
 * @property enableDnsProxy Enable DNS proxy, disabled by default
 * @property enabledDnsType Enabled DNS proxy type, disabled by default
 */
public data class DNSSettingsArgs(
    public val dnsServers: Output<List<IPAddressArgs>>? = null,
    public val enableDnsProxy: Output<Either<String, DNSProxy>>? = null,
    public val enabledDnsType: Output<Either<String, EnabledDNSType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs =
        com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs.builder()
            .dnsServers(
                dnsServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableDnsProxy(
                enableDnsProxy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledDnsType(
                enabledDnsType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DNSSettingsArgs].
 */
@PulumiTagMarker
public class DNSSettingsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<IPAddressArgs>>? = null

    private var enableDnsProxy: Output<Either<String, DNSProxy>>? = null

    private var enabledDnsType: Output<Either<String, EnabledDNSType>>? = null

    /**
     * @param value List of IPs associated with the Firewall
     */
    @JvmName("frncctkokupldxmy")
    public suspend fun dnsServers(`value`: Output<List<IPAddressArgs>>) {
        this.dnsServers = value
    }

    @JvmName("wrplpnpwwwgkboxu")
    public suspend fun dnsServers(vararg values: Output<IPAddressArgs>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of IPs associated with the Firewall
     */
    @JvmName("pvucqgmeanusgftl")
    public suspend fun dnsServers(values: List<Output<IPAddressArgs>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Enable DNS proxy, disabled by default
     */
    @JvmName("ohkfewdqhgyoxmmr")
    public suspend fun enableDnsProxy(`value`: Output<Either<String, DNSProxy>>) {
        this.enableDnsProxy = value
    }

    /**
     * @param value Enabled DNS proxy type, disabled by default
     */
    @JvmName("wrhtowicsdrndaif")
    public suspend fun enabledDnsType(`value`: Output<Either<String, EnabledDNSType>>) {
        this.enabledDnsType = value
    }

    /**
     * @param value List of IPs associated with the Firewall
     */
    @JvmName("pmbkphyxtrhsheit")
    public suspend fun dnsServers(`value`: List<IPAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("wdfoqdeqxtelmxqu")
    public suspend fun dnsServers(argument: List<suspend IPAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dnsServers = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("okfvwqqdrsoguuxs")
    public suspend fun dnsServers(vararg argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dnsServers = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("wfarxwqbhudiabgm")
    public suspend fun dnsServers(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dnsServers = mapped
    }

    /**
     * @param values List of IPs associated with the Firewall
     */
    @JvmName("akmwcugkteahpduw")
    public suspend fun dnsServers(vararg values: IPAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Enable DNS proxy, disabled by default
     */
    @JvmName("jwndfikvehfwiggb")
    public suspend fun enableDnsProxy(`value`: Either<String, DNSProxy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsProxy = mapped
    }

    /**
     * @param value Enable DNS proxy, disabled by default
     */
    @JvmName("phftrydlamxuonxu")
    public fun enableDnsProxy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DNSProxy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDnsProxy = mapped
    }

    /**
     * @param value Enable DNS proxy, disabled by default
     */
    @JvmName("giwgexolbeessjjj")
    public fun enableDnsProxy(`value`: DNSProxy) {
        val toBeMapped = Either.ofRight<String, DNSProxy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDnsProxy = mapped
    }

    /**
     * @param value Enabled DNS proxy type, disabled by default
     */
    @JvmName("kcomsylgmglbiiqx")
    public suspend fun enabledDnsType(`value`: Either<String, EnabledDNSType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledDnsType = mapped
    }

    /**
     * @param value Enabled DNS proxy type, disabled by default
     */
    @JvmName("oapltetuhmryjryj")
    public fun enabledDnsType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledDNSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledDnsType = mapped
    }

    /**
     * @param value Enabled DNS proxy type, disabled by default
     */
    @JvmName("qcawfngtsgtvocim")
    public fun enabledDnsType(`value`: EnabledDNSType) {
        val toBeMapped = Either.ofRight<String, EnabledDNSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledDnsType = mapped
    }

    internal fun build(): DNSSettingsArgs = DNSSettingsArgs(
        dnsServers = dnsServers,
        enableDnsProxy = enableDnsProxy,
        enabledDnsType = enabledDnsType,
    )
}
