@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * destination address
 * @property cidrs special value 'any'
 * @property countries list of countries
 * @property feeds list of feeds
 * @property fqdnLists fqdn list
 * @property prefixLists prefix list
 */
public data class DestinationAddrArgs(
    public val cidrs: Output<List<String>>? = null,
    public val countries: Output<List<String>>? = null,
    public val feeds: Output<List<String>>? = null,
    public val fqdnLists: Output<List<String>>? = null,
    public val prefixLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs =
        com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs.builder()
            .cidrs(cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .countries(countries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feeds(feeds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fqdnLists(fqdnLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixLists(prefixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DestinationAddrArgs].
 */
@PulumiTagMarker
public class DestinationAddrArgsBuilder internal constructor() {
    private var cidrs: Output<List<String>>? = null

    private var countries: Output<List<String>>? = null

    private var feeds: Output<List<String>>? = null

    private var fqdnLists: Output<List<String>>? = null

    private var prefixLists: Output<List<String>>? = null

    /**
     * @param value special value 'any'
     */
    @JvmName("glxrjxvaumglpmoh")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("daorkelnmhcrcfbf")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("apeprwvtiqpcrdfd")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value list of countries
     */
    @JvmName("eolvwykkwmvtuwsf")
    public suspend fun countries(`value`: Output<List<String>>) {
        this.countries = value
    }

    @JvmName("txwngjnylgegsrmt")
    public suspend fun countries(vararg values: Output<String>) {
        this.countries = Output.all(values.asList())
    }

    /**
     * @param values list of countries
     */
    @JvmName("ldvctrcqomwhtpap")
    public suspend fun countries(values: List<Output<String>>) {
        this.countries = Output.all(values)
    }

    /**
     * @param value list of feeds
     */
    @JvmName("yjtvukjjfavjwikv")
    public suspend fun feeds(`value`: Output<List<String>>) {
        this.feeds = value
    }

    @JvmName("lypsfujswiablnyk")
    public suspend fun feeds(vararg values: Output<String>) {
        this.feeds = Output.all(values.asList())
    }

    /**
     * @param values list of feeds
     */
    @JvmName("jsluymtkdawhenuv")
    public suspend fun feeds(values: List<Output<String>>) {
        this.feeds = Output.all(values)
    }

    /**
     * @param value fqdn list
     */
    @JvmName("yketblteukoyqseb")
    public suspend fun fqdnLists(`value`: Output<List<String>>) {
        this.fqdnLists = value
    }

    @JvmName("ckjmgdahyhqckfjf")
    public suspend fun fqdnLists(vararg values: Output<String>) {
        this.fqdnLists = Output.all(values.asList())
    }

    /**
     * @param values fqdn list
     */
    @JvmName("fyjbnxbnghmshgwl")
    public suspend fun fqdnLists(values: List<Output<String>>) {
        this.fqdnLists = Output.all(values)
    }

    /**
     * @param value prefix list
     */
    @JvmName("bedhxwebeeatifbo")
    public suspend fun prefixLists(`value`: Output<List<String>>) {
        this.prefixLists = value
    }

    @JvmName("lvirhpxofmjhcual")
    public suspend fun prefixLists(vararg values: Output<String>) {
        this.prefixLists = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("xnaeobuyjlgimthb")
    public suspend fun prefixLists(values: List<Output<String>>) {
        this.prefixLists = Output.all(values)
    }

    /**
     * @param value special value 'any'
     */
    @JvmName("siqsaxkysomtiytq")
    public suspend fun cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("muqdwcxmkwgswxhm")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param value list of countries
     */
    @JvmName("ljkngsphrpfsupyh")
    public suspend fun countries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param values list of countries
     */
    @JvmName("tovybjswfpfvvsnt")
    public suspend fun countries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param value list of feeds
     */
    @JvmName("yurvegtolggejxkh")
    public suspend fun feeds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param values list of feeds
     */
    @JvmName("vxqbcpgbxalcyqdg")
    public suspend fun feeds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param value fqdn list
     */
    @JvmName("jddypguonasqnfhp")
    public suspend fun fqdnLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnLists = mapped
    }

    /**
     * @param values fqdn list
     */
    @JvmName("wewxplsedntinehw")
    public suspend fun fqdnLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnLists = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("iwkmkdiegqxonyue")
    public suspend fun prefixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("akbitvjywytuqriq")
    public suspend fun prefixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    internal fun build(): DestinationAddrArgs = DestinationAddrArgs(
        cidrs = cidrs,
        countries = countries,
        feeds = feeds,
        fqdnLists = fqdnLists,
        prefixLists = prefixLists,
    )
}
