@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Endpoint Configuration for frontend and backend
 * @property address Address Space
 * @property port port ID
 */
public data class EndpointConfigurationArgs(
    public val address: Output<IPAddressArgs>,
    public val port: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs =
        com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs.builder()
            .address(address.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationArgsBuilder internal constructor() {
    private var address: Output<IPAddressArgs>? = null

    private var port: Output<String>? = null

    /**
     * @param value Address Space
     */
    @JvmName("dwwlwinloroueosq")
    public suspend fun address(`value`: Output<IPAddressArgs>) {
        this.address = value
    }

    /**
     * @param value port ID
     */
    @JvmName("byehoxldhfasumpy")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Address Space
     */
    @JvmName("qbovfykyaawkunsh")
    public suspend fun address(`value`: IPAddressArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param argument Address Space
     */
    @JvmName("mghmdvlbodkqhfsi")
    public suspend fun address(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.address = mapped
    }

    /**
     * @param value port ID
     */
    @JvmName("pithocacdgmhndpr")
    public suspend fun port(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): EndpointConfigurationArgs = EndpointConfigurationArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
