@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectLocalRulestackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property name certificate name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCertificateObjectLocalRulestackPlainArgs(
    public val localRulestackName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectLocalRulestackPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectLocalRulestackPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectLocalRulestackPlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificateObjectLocalRulestackPlainArgs].
 */
@PulumiTagMarker
public class GetCertificateObjectLocalRulestackPlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("rxtgphgxlwkyvxkv")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value certificate name
     */
    @JvmName("frlayvlsrmlpehqv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("evlkvashbsuavhou")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCertificateObjectLocalRulestackPlainArgs =
        GetCertificateObjectLocalRulestackPlainArgs(
            localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
