@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetFirewallLogProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallName Firewall resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFirewallLogProfilePlainArgs(
    public val firewallName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetFirewallLogProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetFirewallLogProfilePlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetFirewallLogProfilePlainArgs.builder()
            .firewallName(firewallName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallLogProfilePlainArgs].
 */
@PulumiTagMarker
public class GetFirewallLogProfilePlainArgsBuilder internal constructor() {
    private var firewallName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Firewall resource name
     */
    @JvmName("bjohtxglbjklsisp")
    public suspend fun firewallName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("glaqjcxhxbhcqlra")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallLogProfilePlainArgs = GetFirewallLogProfilePlainArgs(
        firewallName = firewallName ?: throw PulumiNullFieldException("firewallName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
