@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 */
public data class GetGlobalRulestackPlainArgs(
    public val globalRulestackName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalRulestackPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalRulestackPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("rqmsvtqwkqdhictg")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    internal fun build(): GetGlobalRulestackPlainArgs = GetGlobalRulestackPlainArgs(
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
    )
}
