@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackChangeLogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLocalRulestackChangeLogPlainArgs(
    public val localRulestackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackChangeLogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackChangeLogPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackChangeLogPlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalRulestackChangeLogPlainArgs].
 */
@PulumiTagMarker
public class GetLocalRulestackChangeLogPlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("gevrphhddfxylxqh")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("stbvssfvkbqkwjpl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLocalRulestackChangeLogPlainArgs = GetLocalRulestackChangeLogPlainArgs(
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
