@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackSupportInfoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property email email address on behalf of which this API called
 * @property localRulestackName LocalRulestack resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLocalRulestackSupportInfoPlainArgs(
    public val email: String? = null,
    public val localRulestackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackSupportInfoPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackSupportInfoPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulestackSupportInfoPlainArgs.builder()
            .email(email?.let({ args0 -> args0 }))
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalRulestackSupportInfoPlainArgs].
 */
@PulumiTagMarker
public class GetLocalRulestackSupportInfoPlainArgsBuilder internal constructor() {
    private var email: String? = null

    private var localRulestackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value email address on behalf of which this API called
     */
    @JvmName("dygfullppqljwlax")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.email = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("drdvcscopcsrrpnw")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbrcapagbhabydrc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLocalRulestackSupportInfoPlainArgs =
        GetLocalRulestackSupportInfoPlainArgs(
            email = email,
            localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
