@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetPostRuleCountersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallName
 * @property globalRulestackName GlobalRulestack resource name
 * @property priority Post Rule priority
 */
public data class GetPostRuleCountersPlainArgs(
    public val firewallName: String? = null,
    public val globalRulestackName: String,
    public val priority: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetPostRuleCountersPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetPostRuleCountersPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetPostRuleCountersPlainArgs.builder()
            .firewallName(firewallName?.let({ args0 -> args0 }))
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .priority(priority.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPostRuleCountersPlainArgs].
 */
@PulumiTagMarker
public class GetPostRuleCountersPlainArgsBuilder internal constructor() {
    private var firewallName: String? = null

    private var globalRulestackName: String? = null

    private var priority: String? = null

    /**
     * @param value
     */
    @JvmName("hvpsrvogftuaufgm")
    public suspend fun firewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.firewallName = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("vwjkmvuqagrqaywk")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value Post Rule priority
     */
    @JvmName("nkcheiirytqrndcf")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.priority = mapped
    }

    internal fun build(): GetPostRuleCountersPlainArgs = GetPostRuleCountersPlainArgs(
        firewallName = firewallName,
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
