@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetPostRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 * @property priority Post Rule priority
 */
public data class GetPostRulePlainArgs(
    public val globalRulestackName: String,
    public val priority: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetPostRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetPostRulePlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetPostRulePlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .priority(priority.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPostRulePlainArgs].
 */
@PulumiTagMarker
public class GetPostRulePlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    private var priority: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("klxvrprokyqdllvj")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value Post Rule priority
     */
    @JvmName("lknhvcleritwccov")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.priority = mapped
    }

    internal fun build(): GetPostRulePlainArgs = GetPostRulePlainArgs(
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
