@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetPreRuleCountersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallName
 * @property globalRulestackName GlobalRulestack resource name
 * @property priority Pre Rule priority
 */
public data class GetPreRuleCountersPlainArgs(
    public val firewallName: String? = null,
    public val globalRulestackName: String,
    public val priority: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetPreRuleCountersPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetPreRuleCountersPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetPreRuleCountersPlainArgs.builder()
            .firewallName(firewallName?.let({ args0 -> args0 }))
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .priority(priority.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPreRuleCountersPlainArgs].
 */
@PulumiTagMarker
public class GetPreRuleCountersPlainArgsBuilder internal constructor() {
    private var firewallName: String? = null

    private var globalRulestackName: String? = null

    private var priority: String? = null

    /**
     * @param value
     */
    @JvmName("trjoqyynsshtfyuf")
    public suspend fun firewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.firewallName = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("geudahqnwlugoxer")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value Pre Rule priority
     */
    @JvmName("ssyudpybgphytuhc")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.priority = mapped
    }

    internal fun build(): GetPreRuleCountersPlainArgs = GetPreRuleCountersPlainArgs(
        firewallName = firewallName,
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
