@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListGlobalRulestackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 * @property name Local Rule priority
 */
public data class GetPrefixListGlobalRulestackPlainArgs(
    public val globalRulestackName: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListGlobalRulestackPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListGlobalRulestackPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListGlobalRulestackPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrefixListGlobalRulestackPlainArgs].
 */
@PulumiTagMarker
public class GetPrefixListGlobalRulestackPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    private var name: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("qldmgtvgginuckee")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("xjtyhyahioejscvp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetPrefixListGlobalRulestackPlainArgs =
        GetPrefixListGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
