@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP Address
 * @property address Address value
 * @property resourceId Resource Id
 */
public data class IPAddressArgs(
    public val address: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs =
        com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPAddressArgs].
 */
@PulumiTagMarker
public class IPAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Address value
     */
    @JvmName("qhobloyktfkmvfhl")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("kdhyxrlodmddwnrv")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Address value
     */
    @JvmName("nqhgmgafgywajsrt")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("oqkqukkvlefygeyk")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): IPAddressArgs = IPAddressArgs(
        address = address,
        resourceId = resourceId,
    )
}
