@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP Address Space
 * @property addressSpace Address Space
 * @property resourceId Resource Id
 */
public data class IPAddressSpaceArgs(
    public val addressSpace: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs =
        com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs.builder()
            .addressSpace(addressSpace?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPAddressSpaceArgs].
 */
@PulumiTagMarker
public class IPAddressSpaceArgsBuilder internal constructor() {
    private var addressSpace: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Address Space
     */
    @JvmName("uuokahhoctpfylot")
    public suspend fun addressSpace(`value`: Output<String>) {
        this.addressSpace = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("wwxcngpbwhbchdlo")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Address Space
     */
    @JvmName("xpprvwhotussrmnr")
    public suspend fun addressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("wcdvcivbyhxtqalg")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): IPAddressSpaceArgs = IPAddressSpaceArgs(
        addressSpace = addressSpace,
        resourceId = resourceId,
    )
}
