@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip
 * @property top
 * @property type
 */
public data class ListLocalRulestackAdvancedSecurityObjectsPlainArgs(
    public val localRulestackName: String,
    public val resourceGroupName: String,
    public val skip: String? = null,
    public val top: Int? = null,
    public val type: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListLocalRulestackAdvancedSecurityObjectsPlainArgs].
 */
@PulumiTagMarker
public class ListLocalRulestackAdvancedSecurityObjectsPlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var resourceGroupName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    private var type: String? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("qarufajlitjqkycw")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bqjxkwtdrfcsljdo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("twqxtfjfowjwetsa")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("ffmayljmrqrwfqfh")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpxathplyxobslko")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): ListLocalRulestackAdvancedSecurityObjectsPlainArgs =
        ListLocalRulestackAdvancedSecurityObjectsPlainArgs(
            localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skip = skip,
            top = top,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
