@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.BillingCycle
import com.pulumi.azurenative.cloudngfw.kotlin.enums.UsageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Billing plan information.
 * @property billingCycle different billing cycles like MONTHLY/WEEKLY
 * @property planId plan id as published by Liftr.PAN
 * @property usageType different usage type like PAYG/COMMITTED
 */
public data class PlanDataArgs(
    public val billingCycle: Output<Either<String, BillingCycle>>,
    public val planId: Output<String>,
    public val usageType: Output<Either<String, UsageType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs =
        com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs.builder()
            .billingCycle(
                billingCycle.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .planId(planId.applyValue({ args0 -> args0 }))
            .usageType(
                usageType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlanDataArgs].
 */
@PulumiTagMarker
public class PlanDataArgsBuilder internal constructor() {
    private var billingCycle: Output<Either<String, BillingCycle>>? = null

    private var planId: Output<String>? = null

    private var usageType: Output<Either<String, UsageType>>? = null

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY
     */
    @JvmName("fxgkpfurqduorudo")
    public suspend fun billingCycle(`value`: Output<Either<String, BillingCycle>>) {
        this.billingCycle = value
    }

    /**
     * @param value plan id as published by Liftr.PAN
     */
    @JvmName("leiefcwbxvcroqnu")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value different usage type like PAYG/COMMITTED
     */
    @JvmName("plynlwekokjslynf")
    public suspend fun usageType(`value`: Output<Either<String, UsageType>>) {
        this.usageType = value
    }

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY
     */
    @JvmName("ahvsdglunhkussso")
    public suspend fun billingCycle(`value`: Either<String, BillingCycle>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingCycle = mapped
    }

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY
     */
    @JvmName("gxliddlxfygmbvlu")
    public fun billingCycle(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BillingCycle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingCycle = mapped
    }

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY
     */
    @JvmName("nikchlhraoshfyaq")
    public fun billingCycle(`value`: BillingCycle) {
        val toBeMapped = Either.ofRight<String, BillingCycle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingCycle = mapped
    }

    /**
     * @param value plan id as published by Liftr.PAN
     */
    @JvmName("ndimgrpcqynvegju")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value different usage type like PAYG/COMMITTED
     */
    @JvmName("dlhxkuehegsxeaws")
    public suspend fun usageType(`value`: Either<String, UsageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    /**
     * @param value different usage type like PAYG/COMMITTED
     */
    @JvmName("jdtwqalnhbylgdbv")
    public fun usageType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    /**
     * @param value different usage type like PAYG/COMMITTED
     */
    @JvmName("txabhdpppbkxjjpe")
    public fun usageType(`value`: UsageType) {
        val toBeMapped = Either.ofRight<String, UsageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    internal fun build(): PlanDataArgs = PlanDataArgs(
        billingCycle = billingCycle ?: throw PulumiNullFieldException("billingCycle"),
        planId = planId ?: throw PulumiNullFieldException("planId"),
        usageType = usageType,
    )
}
