@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Address properties
 * @property cidrs special value 'any'
 * @property countries list of countries
 * @property feeds list of feeds
 * @property prefixLists prefix list
 */
public data class SourceAddrArgs(
    public val cidrs: Output<List<String>>? = null,
    public val countries: Output<List<String>>? = null,
    public val feeds: Output<List<String>>? = null,
    public val prefixLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs =
        com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs.builder()
            .cidrs(cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .countries(countries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feeds(feeds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixLists(prefixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SourceAddrArgs].
 */
@PulumiTagMarker
public class SourceAddrArgsBuilder internal constructor() {
    private var cidrs: Output<List<String>>? = null

    private var countries: Output<List<String>>? = null

    private var feeds: Output<List<String>>? = null

    private var prefixLists: Output<List<String>>? = null

    /**
     * @param value special value 'any'
     */
    @JvmName("teeogtgwddkalmrk")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("wygbgmwmoirulvjj")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("ngmlasqcdapmeiho")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value list of countries
     */
    @JvmName("ceiyupcketuciehw")
    public suspend fun countries(`value`: Output<List<String>>) {
        this.countries = value
    }

    @JvmName("ksodctnvtgpgngkj")
    public suspend fun countries(vararg values: Output<String>) {
        this.countries = Output.all(values.asList())
    }

    /**
     * @param values list of countries
     */
    @JvmName("htdljsmgnubytgkp")
    public suspend fun countries(values: List<Output<String>>) {
        this.countries = Output.all(values)
    }

    /**
     * @param value list of feeds
     */
    @JvmName("ijyvmbelhxjhjcui")
    public suspend fun feeds(`value`: Output<List<String>>) {
        this.feeds = value
    }

    @JvmName("pkejgykeoayucfhb")
    public suspend fun feeds(vararg values: Output<String>) {
        this.feeds = Output.all(values.asList())
    }

    /**
     * @param values list of feeds
     */
    @JvmName("ovtsjhjedbquasla")
    public suspend fun feeds(values: List<Output<String>>) {
        this.feeds = Output.all(values)
    }

    /**
     * @param value prefix list
     */
    @JvmName("ghbugyapwjfrcutm")
    public suspend fun prefixLists(`value`: Output<List<String>>) {
        this.prefixLists = value
    }

    @JvmName("wsnkeqtrpkjlqtmq")
    public suspend fun prefixLists(vararg values: Output<String>) {
        this.prefixLists = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("hkectabxouylqlof")
    public suspend fun prefixLists(values: List<Output<String>>) {
        this.prefixLists = Output.all(values)
    }

    /**
     * @param value special value 'any'
     */
    @JvmName("xdgwtsayfiqfbkfs")
    public suspend fun cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("eekffbcbfjdcjoba")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param value list of countries
     */
    @JvmName("mdglfechsmgroedu")
    public suspend fun countries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param values list of countries
     */
    @JvmName("xcntyglqxbapkxnw")
    public suspend fun countries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param value list of feeds
     */
    @JvmName("ekyliakynuejfhef")
    public suspend fun feeds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param values list of feeds
     */
    @JvmName("halqiydmqamgiprc")
    public suspend fun feeds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("yccogskvvwwjsfby")
    public suspend fun prefixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("cnyluekokkkcjgdl")
    public suspend fun prefixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    internal fun build(): SourceAddrArgs = SourceAddrArgs(
        cidrs = cidrs,
        countries = countries,
        feeds = feeds,
        prefixLists = prefixLists,
    )
}
