@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * VnetInfo for Firewall Networking
 * @property ipOfTrustSubnetForUdr IP of trust subnet for UDR
 * @property trustSubnet Trust Subnet
 * @property unTrustSubnet Untrust Subnet
 * @property vnet Azure Virtual Network
 */
public data class VnetConfigurationArgs(
    public val ipOfTrustSubnetForUdr: Output<IPAddressArgs>? = null,
    public val trustSubnet: Output<IPAddressSpaceArgs>,
    public val unTrustSubnet: Output<IPAddressSpaceArgs>,
    public val vnet: Output<IPAddressSpaceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs =
        com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs.builder()
            .ipOfTrustSubnetForUdr(
                ipOfTrustSubnetForUdr?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trustSubnet(trustSubnet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unTrustSubnet(unTrustSubnet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vnet(vnet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VnetConfigurationArgs].
 */
@PulumiTagMarker
public class VnetConfigurationArgsBuilder internal constructor() {
    private var ipOfTrustSubnetForUdr: Output<IPAddressArgs>? = null

    private var trustSubnet: Output<IPAddressSpaceArgs>? = null

    private var unTrustSubnet: Output<IPAddressSpaceArgs>? = null

    private var vnet: Output<IPAddressSpaceArgs>? = null

    /**
     * @param value IP of trust subnet for UDR
     */
    @JvmName("xguxtdisbidschfe")
    public suspend fun ipOfTrustSubnetForUdr(`value`: Output<IPAddressArgs>) {
        this.ipOfTrustSubnetForUdr = value
    }

    /**
     * @param value Trust Subnet
     */
    @JvmName("ltlewpkdksmlkfhf")
    public suspend fun trustSubnet(`value`: Output<IPAddressSpaceArgs>) {
        this.trustSubnet = value
    }

    /**
     * @param value Untrust Subnet
     */
    @JvmName("mqrkvwjwheltnifv")
    public suspend fun unTrustSubnet(`value`: Output<IPAddressSpaceArgs>) {
        this.unTrustSubnet = value
    }

    /**
     * @param value Azure Virtual Network
     */
    @JvmName("udweduahkrotlevm")
    public suspend fun vnet(`value`: Output<IPAddressSpaceArgs>) {
        this.vnet = value
    }

    /**
     * @param value IP of trust subnet for UDR
     */
    @JvmName("sbsiduluvrrxbewy")
    public suspend fun ipOfTrustSubnetForUdr(`value`: IPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipOfTrustSubnetForUdr = mapped
    }

    /**
     * @param argument IP of trust subnet for UDR
     */
    @JvmName("ysgbfabqxekoqywg")
    public suspend fun ipOfTrustSubnetForUdr(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipOfTrustSubnetForUdr = mapped
    }

    /**
     * @param value Trust Subnet
     */
    @JvmName("rqersoifpevimbdr")
    public suspend fun trustSubnet(`value`: IPAddressSpaceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustSubnet = mapped
    }

    /**
     * @param argument Trust Subnet
     */
    @JvmName("rqjpramckktwmcdi")
    public suspend fun trustSubnet(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trustSubnet = mapped
    }

    /**
     * @param value Untrust Subnet
     */
    @JvmName("mgmighxtknqmtjkr")
    public suspend fun unTrustSubnet(`value`: IPAddressSpaceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unTrustSubnet = mapped
    }

    /**
     * @param argument Untrust Subnet
     */
    @JvmName("aosucbmvuqcufqiv")
    public suspend fun unTrustSubnet(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.unTrustSubnet = mapped
    }

    /**
     * @param value Azure Virtual Network
     */
    @JvmName("amocddscjojosmdr")
    public suspend fun vnet(`value`: IPAddressSpaceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vnet = mapped
    }

    /**
     * @param argument Azure Virtual Network
     */
    @JvmName("coxwuvdnbaejccrs")
    public suspend fun vnet(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnet = mapped
    }

    internal fun build(): VnetConfigurationArgs = VnetConfigurationArgs(
        ipOfTrustSubnetForUdr = ipOfTrustSubnetForUdr,
        trustSubnet = trustSubnet ?: throw PulumiNullFieldException("trustSubnet"),
        unTrustSubnet = unTrustSubnet ?: throw PulumiNullFieldException("unTrustSubnet"),
        vnet = vnet ?: throw PulumiNullFieldException("vnet"),
    )
}
