@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * VwanInfo for Firewall Networking
 * @property ipOfTrustSubnetForUdr IP of trust subnet for UDR
 * @property networkVirtualApplianceId Network Virtual Appliance resource ID
 * @property trustSubnet Trust Subnet
 * @property unTrustSubnet Untrust Subnet
 * @property vHub vHub Address
 */
public data class VwanConfigurationArgs(
    public val ipOfTrustSubnetForUdr: Output<IPAddressArgs>? = null,
    public val networkVirtualApplianceId: Output<String>? = null,
    public val trustSubnet: Output<IPAddressSpaceArgs>? = null,
    public val unTrustSubnet: Output<IPAddressSpaceArgs>? = null,
    public val vHub: Output<IPAddressSpaceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs =
        com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs.builder()
            .ipOfTrustSubnetForUdr(
                ipOfTrustSubnetForUdr?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkVirtualApplianceId(networkVirtualApplianceId?.applyValue({ args0 -> args0 }))
            .trustSubnet(trustSubnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unTrustSubnet(unTrustSubnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vHub(vHub.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VwanConfigurationArgs].
 */
@PulumiTagMarker
public class VwanConfigurationArgsBuilder internal constructor() {
    private var ipOfTrustSubnetForUdr: Output<IPAddressArgs>? = null

    private var networkVirtualApplianceId: Output<String>? = null

    private var trustSubnet: Output<IPAddressSpaceArgs>? = null

    private var unTrustSubnet: Output<IPAddressSpaceArgs>? = null

    private var vHub: Output<IPAddressSpaceArgs>? = null

    /**
     * @param value IP of trust subnet for UDR
     */
    @JvmName("rcwyjrwnndkwjaxu")
    public suspend fun ipOfTrustSubnetForUdr(`value`: Output<IPAddressArgs>) {
        this.ipOfTrustSubnetForUdr = value
    }

    /**
     * @param value Network Virtual Appliance resource ID
     */
    @JvmName("qgwsdqanyiqtwyqn")
    public suspend fun networkVirtualApplianceId(`value`: Output<String>) {
        this.networkVirtualApplianceId = value
    }

    /**
     * @param value Trust Subnet
     */
    @JvmName("qqoyiehnakloqhpq")
    public suspend fun trustSubnet(`value`: Output<IPAddressSpaceArgs>) {
        this.trustSubnet = value
    }

    /**
     * @param value Untrust Subnet
     */
    @JvmName("gnwggmyxtdbhwkap")
    public suspend fun unTrustSubnet(`value`: Output<IPAddressSpaceArgs>) {
        this.unTrustSubnet = value
    }

    /**
     * @param value vHub Address
     */
    @JvmName("flumpercbwuvxmaq")
    public suspend fun vHub(`value`: Output<IPAddressSpaceArgs>) {
        this.vHub = value
    }

    /**
     * @param value IP of trust subnet for UDR
     */
    @JvmName("spogwlbjfwbfqmkm")
    public suspend fun ipOfTrustSubnetForUdr(`value`: IPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipOfTrustSubnetForUdr = mapped
    }

    /**
     * @param argument IP of trust subnet for UDR
     */
    @JvmName("arwebdxvnattapjg")
    public suspend fun ipOfTrustSubnetForUdr(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipOfTrustSubnetForUdr = mapped
    }

    /**
     * @param value Network Virtual Appliance resource ID
     */
    @JvmName("wuleupburkkgybgs")
    public suspend fun networkVirtualApplianceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkVirtualApplianceId = mapped
    }

    /**
     * @param value Trust Subnet
     */
    @JvmName("ogyiwbscshbqfwmo")
    public suspend fun trustSubnet(`value`: IPAddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustSubnet = mapped
    }

    /**
     * @param argument Trust Subnet
     */
    @JvmName("cutgmxieeivysvvg")
    public suspend fun trustSubnet(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trustSubnet = mapped
    }

    /**
     * @param value Untrust Subnet
     */
    @JvmName("fxmyflpmmgvehedr")
    public suspend fun unTrustSubnet(`value`: IPAddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unTrustSubnet = mapped
    }

    /**
     * @param argument Untrust Subnet
     */
    @JvmName("kaswwyrmhdjxgqut")
    public suspend fun unTrustSubnet(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.unTrustSubnet = mapped
    }

    /**
     * @param value vHub Address
     */
    @JvmName("ogsstpyvtspyoiep")
    public suspend fun vHub(`value`: IPAddressSpaceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vHub = mapped
    }

    /**
     * @param argument vHub Address
     */
    @JvmName("rcjprrwvfjltendr")
    public suspend fun vHub(argument: suspend IPAddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = IPAddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vHub = mapped
    }

    internal fun build(): VwanConfigurationArgs = VwanConfigurationArgs(
        ipOfTrustSubnetForUdr = ipOfTrustSubnetForUdr,
        networkVirtualApplianceId = networkVirtualApplianceId,
        trustSubnet = trustSubnet,
        unTrustSubnet = unTrustSubnet,
        vHub = vHub ?: throw PulumiNullFieldException("vHub"),
    )
}
