@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The properties of the managed service identities assigned to this resource.
 * @property principalId The active directory identifier of this principal.
 * @property tenantId The Active Directory tenant id of the principal.
 * @property type The type of managed identity assigned to this resource.
 * @property userAssignedIdentities The identities assigned to this resource by the user.
 */
public data class AzureResourceManagerManagedIdentityPropertiesResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, AzureResourceManagerUserAssignedIdentityResponse>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.AzureResourceManagerManagedIdentityPropertiesResponse):
            AzureResourceManagerManagedIdentityPropertiesResponse =
            AzureResourceManagerManagedIdentityPropertiesResponse(
                principalId = javaType.principalId(),
                tenantId = javaType.tenantId(),
                type = javaType.type(),
                userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerUserAssignedIdentityResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
            )
    }
}
