@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A managed identity assigned by the user.
 * @property clientId The active directory client identifier for this principal.
 * @property principalId The active directory identifier for this principal.
 */
public data class AzureResourceManagerUserAssignedIdentityResponse(
    public val clientId: String? = null,
    public val principalId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.AzureResourceManagerUserAssignedIdentityResponse):
            AzureResourceManagerUserAssignedIdentityResponse =
            AzureResourceManagerUserAssignedIdentityResponse(
                clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
                principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
