@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * URL/EDL to match
 * @property feeds feed list
 * @property urlCustom custom URL
 */
public data class CategoryResponse(
    public val feeds: List<String>,
    public val urlCustom: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.CategoryResponse):
            CategoryResponse = CategoryResponse(
            feeds = javaType.feeds().map({ args0 -> args0 }),
            urlCustom = javaType.urlCustom().map({ args0 -> args0 }),
        )
    }
}
