@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Frontend setting for Firewall
 * @property backendConfiguration Backend configurations
 * @property frontendConfiguration Frontend configurations
 * @property name Settings name
 * @property protocol Protocol Type
 */
public data class FrontendSettingResponse(
    public val backendConfiguration: EndpointConfigurationResponse,
    public val frontendConfiguration: EndpointConfigurationResponse,
    public val name: String,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.FrontendSettingResponse):
            FrontendSettingResponse = FrontendSettingResponse(
            backendConfiguration = javaType.backendConfiguration().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.EndpointConfigurationResponse.Companion.toKotlin(args0)
            }),
            frontendConfiguration = javaType.frontendConfiguration().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.EndpointConfigurationResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            protocol = javaType.protocol(),
        )
    }
}
