@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * PaloAltoNetworks Firewall
 * @property associatedRulestack Associated Rulestack
 * @property dnsSettings DNS settings for Firewall
 * @property frontEndSettings Frontend settings for Firewall
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed service identities assigned to this resource.
 * @property isPanoramaManaged Panorama Managed: Default is False. Default will be CloudSec managed
 * @property location The geo-location where the resource lives
 * @property marketplaceDetails Marketplace details
 * @property name The name of the resource
 * @property networkProfile Network settings
 * @property panEtag panEtag info
 * @property panoramaConfig Panorama Configuration
 * @property planData Billing plan information.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFirewallResult(
    public val associatedRulestack: RulestackDetailsResponse? = null,
    public val dnsSettings: DNSSettingsResponse,
    public val frontEndSettings: List<FrontendSettingResponse>? = null,
    public val id: String,
    public val identity: AzureResourceManagerManagedIdentityPropertiesResponse? = null,
    public val isPanoramaManaged: String? = null,
    public val location: String,
    public val marketplaceDetails: MarketplaceDetailsResponse,
    public val name: String,
    public val networkProfile: NetworkProfileResponse,
    public val panEtag: String? = null,
    public val panoramaConfig: PanoramaConfigResponse? = null,
    public val planData: PlanDataResponse,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetFirewallResult):
            GetFirewallResult = GetFirewallResult(
            associatedRulestack = javaType.associatedRulestack().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.RulestackDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dnsSettings = javaType.dnsSettings().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.DNSSettingsResponse.Companion.toKotlin(args0)
            }),
            frontEndSettings = javaType.frontEndSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.FrontendSettingResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isPanoramaManaged = javaType.isPanoramaManaged().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            marketplaceDetails = javaType.marketplaceDetails().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.MarketplaceDetailsResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
            }),
            panEtag = javaType.panEtag().map({ args0 -> args0 }).orElse(null),
            panoramaConfig = javaType.panoramaConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.PanoramaConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            planData = javaType.planData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.PlanDataResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
