@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * PaloAltoNetworks LocalRulestack
 * @property associatedSubscriptions subscription scope of global rulestack
 * @property defaultMode Mode for default rules creation
 * @property description rulestack description
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property minAppIdVersion minimum version
 * @property name The name of the resource
 * @property panEtag PanEtag info
 * @property panLocation Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
 * @property provisioningState Provisioning state of the resource.
 * @property scope Rulestack Type
 * @property securityServices Security Profile
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLocalRulestackResult(
    public val associatedSubscriptions: List<String>? = null,
    public val defaultMode: String? = null,
    public val description: String? = null,
    public val id: String,
    public val identity: AzureResourceManagerManagedIdentityPropertiesResponse? = null,
    public val location: String,
    public val minAppIdVersion: String? = null,
    public val name: String,
    public val panEtag: String? = null,
    public val panLocation: String? = null,
    public val provisioningState: String,
    public val scope: String? = null,
    public val securityServices: SecurityServicesResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetLocalRulestackResult):
            GetLocalRulestackResult = GetLocalRulestackResult(
            associatedSubscriptions = javaType.associatedSubscriptions().map({ args0 -> args0 }),
            defaultMode = javaType.defaultMode().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            minAppIdVersion = javaType.minAppIdVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            panEtag = javaType.panEtag().map({ args0 -> args0 }).orElse(null),
            panLocation = javaType.panLocation().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            securityServices = javaType.securityServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.SecurityServicesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
