@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Support information for the resource
 * @property accountId Support account associated with given resource
 * @property accountRegistered account registered in Customer Support Portal
 * @property freeTrial Product usage is in free trial period
 * @property freeTrialCreditLeft Free trial credit remaining
 * @property freeTrialDaysLeft Free trial days remaining
 * @property helpURL URL for paloaltonetworks live community
 * @property productSerial product Serial associated with given resource
 * @property productSku product SKU associated with given resource
 * @property registerURL URL for registering product in paloaltonetworks Customer Service Portal
 * @property supportURL URL for paloaltonetworks Customer Service Portal
 * @property userDomainSupported user domain is supported in Customer Support Portal
 * @property userRegistered user registered in Customer Support Portal
 */
public data class GetLocalRulestackSupportInfoResult(
    public val accountId: String? = null,
    public val accountRegistered: String? = null,
    public val freeTrial: String? = null,
    public val freeTrialCreditLeft: Int? = null,
    public val freeTrialDaysLeft: Int? = null,
    public val helpURL: String? = null,
    public val productSerial: String? = null,
    public val productSku: String? = null,
    public val registerURL: String? = null,
    public val supportURL: String? = null,
    public val userDomainSupported: String? = null,
    public val userRegistered: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetLocalRulestackSupportInfoResult):
            GetLocalRulestackSupportInfoResult = GetLocalRulestackSupportInfoResult(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            accountRegistered = javaType.accountRegistered().map({ args0 -> args0 }).orElse(null),
            freeTrial = javaType.freeTrial().map({ args0 -> args0 }).orElse(null),
            freeTrialCreditLeft = javaType.freeTrialCreditLeft().map({ args0 -> args0 }).orElse(null),
            freeTrialDaysLeft = javaType.freeTrialDaysLeft().map({ args0 -> args0 }).orElse(null),
            helpURL = javaType.helpURL().map({ args0 -> args0 }).orElse(null),
            productSerial = javaType.productSerial().map({ args0 -> args0 }).orElse(null),
            productSku = javaType.productSku().map({ args0 -> args0 }).orElse(null),
            registerURL = javaType.registerURL().map({ args0 -> args0 }).orElse(null),
            supportURL = javaType.supportURL().map({ args0 -> args0 }).orElse(null),
            userDomainSupported = javaType.userDomainSupported().map({ args0 -> args0 }).orElse(null),
            userRegistered = javaType.userRegistered().map({ args0 -> args0 }).orElse(null),
        )
    }
}
