@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * PostRulestack rule list
 * @property actionType rule action
 * @property applications array of rule applications
 * @property auditComment rule comment
 * @property category rule category
 * @property decryptionRuleType enable or disable decryption
 * @property description rule description
 * @property destination destination address
 * @property enableLogging enable or disable logging
 * @property etag etag info
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property inboundInspectionCertificate inbound Inspection Certificate
 * @property name The name of the resource
 * @property negateDestination cidr should not be 'any'
 * @property negateSource cidr should not be 'any'
 * @property priority
 * @property protocol any, application-default, TCP:number, UDP:number
 * @property protocolPortList prot port list
 * @property provisioningState Provisioning state of the resource.
 * @property ruleName rule name
 * @property ruleState state of this rule
 * @property source source address
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags tag for rule
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPostRuleResult(
    public val actionType: String? = null,
    public val applications: List<String>? = null,
    public val auditComment: String? = null,
    public val category: CategoryResponse? = null,
    public val decryptionRuleType: String? = null,
    public val description: String? = null,
    public val destination: DestinationAddrResponse? = null,
    public val enableLogging: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val inboundInspectionCertificate: String? = null,
    public val name: String,
    public val negateDestination: String? = null,
    public val negateSource: String? = null,
    public val priority: Int,
    public val protocol: String? = null,
    public val protocolPortList: List<String>? = null,
    public val provisioningState: String,
    public val ruleName: String,
    public val ruleState: String? = null,
    public val source: SourceAddrResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: List<TagInfoResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetPostRuleResult):
            GetPostRuleResult = GetPostRuleResult(
            actionType = javaType.actionType().map({ args0 -> args0 }).orElse(null),
            applications = javaType.applications().map({ args0 -> args0 }),
            auditComment = javaType.auditComment().map({ args0 -> args0 }).orElse(null),
            category = javaType.category().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.CategoryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            decryptionRuleType = javaType.decryptionRuleType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.DestinationAddrResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableLogging = javaType.enableLogging().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            inboundInspectionCertificate = javaType.inboundInspectionCertificate().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            negateDestination = javaType.negateDestination().map({ args0 -> args0 }).orElse(null),
            negateSource = javaType.negateSource().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            protocolPortList = javaType.protocolPortList().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            ruleName = javaType.ruleName(),
            ruleState = javaType.ruleState().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.SourceAddrResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.TagInfoResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
