@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Rule counter
 * @property appSeen apps seen
 * @property firewallName firewall name
 * @property hitCount hit count
 * @property lastUpdatedTimestamp last updated timestamp
 * @property priority priority number
 * @property requestTimestamp timestamp of request
 * @property ruleListName rule list name
 * @property ruleName rule name
 * @property ruleStackName rule Stack Name
 * @property timestamp timestamp of response
 */
public data class GetPreRuleCountersResult(
    public val appSeen: AppSeenDataResponse? = null,
    public val firewallName: String? = null,
    public val hitCount: Int? = null,
    public val lastUpdatedTimestamp: String? = null,
    public val priority: String,
    public val requestTimestamp: String? = null,
    public val ruleListName: String? = null,
    public val ruleName: String,
    public val ruleStackName: String? = null,
    public val timestamp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetPreRuleCountersResult):
            GetPreRuleCountersResult = GetPreRuleCountersResult(
            appSeen = javaType.appSeen().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.AppSeenDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firewallName = javaType.firewallName().map({ args0 -> args0 }).orElse(null),
            hitCount = javaType.hitCount().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            requestTimestamp = javaType.requestTimestamp().map({ args0 -> args0 }).orElse(null),
            ruleListName = javaType.ruleListName().map({ args0 -> args0 }).orElse(null),
            ruleName = javaType.ruleName(),
            ruleStackName = javaType.ruleStackName().map({ args0 -> args0 }).orElse(null),
            timestamp = javaType.timestamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
