@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Support information for the service
 * @property accountId Support account associated with given resource
 * @property accountRegistrationStatus account registered in Customer Support Portal
 * @property credits credits purchased, unit per hour
 * @property endDateForCredits date in format yyyy-mm-dd
 * @property freeTrial Product usage is in free trial period
 * @property freeTrialCreditLeft Free trial credit remaining
 * @property freeTrialDaysLeft Free trial days remaining
 * @property helpURL URL for paloaltonetworks live community
 * @property hubUrl URL for Strata Cloud Manager
 * @property monthlyCreditLeft monthly credit is computed as credits * days in calendar month
 * @property productSerial product Serial associated with given resource
 * @property productSku product SKU associated with given resource
 * @property registerURL URL for registering product in paloaltonetworks Customer Service Portal
 * @property startDateForCredits date in format yyyy-mm-dd
 * @property supportURL URL for paloaltonetworks Customer Service Portal
 */
public data class ListPaloAltoNetworksCloudngfwSupportInfoResult(
    public val accountId: String? = null,
    public val accountRegistrationStatus: String? = null,
    public val credits: Int? = null,
    public val endDateForCredits: String? = null,
    public val freeTrial: String? = null,
    public val freeTrialCreditLeft: Int? = null,
    public val freeTrialDaysLeft: Int? = null,
    public val helpURL: String? = null,
    public val hubUrl: String? = null,
    public val monthlyCreditLeft: Int? = null,
    public val productSerial: String? = null,
    public val productSku: String? = null,
    public val registerURL: String? = null,
    public val startDateForCredits: String? = null,
    public val supportURL: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.ListPaloAltoNetworksCloudngfwSupportInfoResult):
            ListPaloAltoNetworksCloudngfwSupportInfoResult =
            ListPaloAltoNetworksCloudngfwSupportInfoResult(
                accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
                accountRegistrationStatus = javaType.accountRegistrationStatus().map({ args0 ->
                    args0
                }).orElse(null),
                credits = javaType.credits().map({ args0 -> args0 }).orElse(null),
                endDateForCredits = javaType.endDateForCredits().map({ args0 -> args0 }).orElse(null),
                freeTrial = javaType.freeTrial().map({ args0 -> args0 }).orElse(null),
                freeTrialCreditLeft = javaType.freeTrialCreditLeft().map({ args0 -> args0 }).orElse(null),
                freeTrialDaysLeft = javaType.freeTrialDaysLeft().map({ args0 -> args0 }).orElse(null),
                helpURL = javaType.helpURL().map({ args0 -> args0 }).orElse(null),
                hubUrl = javaType.hubUrl().map({ args0 -> args0 }).orElse(null),
                monthlyCreditLeft = javaType.monthlyCreditLeft().map({ args0 -> args0 }).orElse(null),
                productSerial = javaType.productSerial().map({ args0 -> args0 }).orElse(null),
                productSku = javaType.productSku().map({ args0 -> args0 }).orElse(null),
                registerURL = javaType.registerURL().map({ args0 -> args0 }).orElse(null),
                startDateForCredits = javaType.startDateForCredits().map({ args0 -> args0 }).orElse(null),
                supportURL = javaType.supportURL().map({ args0 -> args0 }).orElse(null),
            )
    }
}
