@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MarketplaceDetails of PAN Firewall resource
 * @property marketplaceSubscriptionId Marketplace Subscription Id
 * @property marketplaceSubscriptionStatus Marketplace Subscription Status
 * @property offerId Offer Id
 * @property publisherId Publisher Id
 */
public data class MarketplaceDetailsResponse(
    public val marketplaceSubscriptionId: String,
    public val marketplaceSubscriptionStatus: String? = null,
    public val offerId: String,
    public val publisherId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.MarketplaceDetailsResponse):
            MarketplaceDetailsResponse = MarketplaceDetailsResponse(
            marketplaceSubscriptionId = javaType.marketplaceSubscriptionId(),
            marketplaceSubscriptionStatus = javaType.marketplaceSubscriptionStatus().map({ args0 ->
                args0
            }).orElse(null),
            offerId = javaType.offerId(),
            publisherId = javaType.publisherId(),
        )
    }
}
