@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Billing plan information.
 * @property billingCycle different billing cycles like MONTHLY/WEEKLY
 * @property effectiveDate date when plan was applied
 * @property planId plan id as published by Liftr.PAN
 * @property usageType different usage type like PAYG/COMMITTED
 */
public data class PlanDataResponse(
    public val billingCycle: String,
    public val effectiveDate: String,
    public val planId: String,
    public val usageType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.PlanDataResponse):
            PlanDataResponse = PlanDataResponse(
            billingCycle = javaType.billingCycle(),
            effectiveDate = javaType.effectiveDate(),
            planId = javaType.planId(),
            usageType = javaType.usageType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
