@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * security services
 * @property antiSpywareProfile Anti spyware Profile data
 * @property antiVirusProfile anti virus profile data
 * @property dnsSubscription DNS Subscription profile data
 * @property fileBlockingProfile File blocking profile data
 * @property outboundTrustCertificate Trusted Egress Decryption profile data
 * @property outboundUnTrustCertificate Untrusted Egress Decryption profile data
 * @property urlFilteringProfile URL filtering profile data
 * @property vulnerabilityProfile IPs Vulnerability Profile Data
 */
public data class SecurityServicesResponse(
    public val antiSpywareProfile: String? = null,
    public val antiVirusProfile: String? = null,
    public val dnsSubscription: String? = null,
    public val fileBlockingProfile: String? = null,
    public val outboundTrustCertificate: String? = null,
    public val outboundUnTrustCertificate: String? = null,
    public val urlFilteringProfile: String? = null,
    public val vulnerabilityProfile: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.SecurityServicesResponse):
            SecurityServicesResponse = SecurityServicesResponse(
            antiSpywareProfile = javaType.antiSpywareProfile().map({ args0 -> args0 }).orElse(null),
            antiVirusProfile = javaType.antiVirusProfile().map({ args0 -> args0 }).orElse(null),
            dnsSubscription = javaType.dnsSubscription().map({ args0 -> args0 }).orElse(null),
            fileBlockingProfile = javaType.fileBlockingProfile().map({ args0 -> args0 }).orElse(null),
            outboundTrustCertificate = javaType.outboundTrustCertificate().map({ args0 -> args0 }).orElse(null),
            outboundUnTrustCertificate = javaType.outboundUnTrustCertificate().map({ args0 ->
                args0
            }).orElse(null),
            urlFilteringProfile = javaType.urlFilteringProfile().map({ args0 -> args0 }).orElse(null),
            vulnerabilityProfile = javaType.vulnerabilityProfile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
