@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Suppress

/**
 * VnetInfo for Firewall Networking
 * @property ipOfTrustSubnetForUdr IP of trust subnet for UDR
 * @property trustSubnet Trust Subnet
 * @property unTrustSubnet Untrust Subnet
 * @property vnet Azure Virtual Network
 */
public data class VnetConfigurationResponse(
    public val ipOfTrustSubnetForUdr: IPAddressResponse? = null,
    public val trustSubnet: IPAddressSpaceResponse,
    public val unTrustSubnet: IPAddressSpaceResponse,
    public val vnet: IPAddressSpaceResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.VnetConfigurationResponse):
            VnetConfigurationResponse = VnetConfigurationResponse(
            ipOfTrustSubnetForUdr = javaType.ipOfTrustSubnetForUdr().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trustSubnet = javaType.trustSubnet().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
            }),
            unTrustSubnet = javaType.unTrustSubnet().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
            }),
            vnet = javaType.vnet().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
